/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAGNotRunningException;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientInternal;
import org.apache.tez.dag.api.client.DAGClientTimelineImpl;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.DagStatusSource;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientRPCImpl;
import org.apache.tez.dag.api.records.DAGProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DAGClientImpl
extends DAGClient {
    private static final Logger LOG = LoggerFactory.getLogger(DAGClientImpl.class);
    private final ApplicationId appId;
    private final String dagId;
    private final TezConfiguration conf;
    private final FrameworkClient frameworkClient;
    @VisibleForTesting
    protected DAGClientInternal realClient;
    private boolean dagCompleted = false;
    @VisibleForTesting
    protected boolean isATSEnabled = false;
    private DAGStatus cachedDagStatus = null;
    Map<String, VertexStatus> cachedVertexStatus = new HashMap<String, VertexStatus>();
    private static final long SLEEP_FOR_COMPLETION = 500L;
    private static final long PRINT_STATUS_INTERVAL_MILLIS = 5000L;
    private final DecimalFormat formatter = new DecimalFormat("###.##%");
    private long lastPrintStatusTimeMillis;
    private EnumSet<VertexStatus.State> vertexCompletionStates = EnumSet.of(VertexStatus.State.SUCCEEDED, VertexStatus.State.FAILED, VertexStatus.State.KILLED, VertexStatus.State.ERROR);
    private long statusPollInterval;
    private long diagnoticsWaitTimeout;

    public DAGClientImpl(ApplicationId appId, String dagId, TezConfiguration conf, @Nullable FrameworkClient frameworkClient) {
        this.appId = appId;
        this.dagId = dagId;
        this.conf = conf;
        if (frameworkClient != null && conf.getBoolean("tez.local.mode", false)) {
            this.frameworkClient = frameworkClient;
        } else {
            this.frameworkClient = FrameworkClient.createFrameworkClient(conf);
            this.frameworkClient.init(conf, new YarnConfiguration((Configuration)conf));
            this.frameworkClient.start();
        }
        this.isATSEnabled = conf.get("tez.history.logging.service.class", "").equals("org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService") && conf.getBoolean("tez.dag.history.logging.enabled", true) && conf.getBoolean("tez.am.history.logging.enabled", true) && DAGClientTimelineImpl.isSupported();
        this.realClient = new DAGClientRPCImpl(appId, dagId, conf, this.frameworkClient);
        this.statusPollInterval = conf.getLong("tez.dag.status.pollinterval-ms", 500L);
        if (this.statusPollInterval < 0L) {
            LOG.error("DAG Status poll interval cannot be negative and setting to default value.");
            this.statusPollInterval = 500L;
        }
        this.diagnoticsWaitTimeout = conf.getLong("tez.client.diagnostics.wait.timeout-ms", 3000L);
    }

    @Override
    public String getExecutionContext() {
        return this.realClient.getExecutionContext();
    }

    @Override
    protected ApplicationReport getApplicationReportInternal() {
        return this.realClient.getApplicationReportInternal();
    }

    @Override
    public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws TezException, IOException {
        boolean refreshStatus;
        DAGStatus dagStatus;
        Preconditions.checkArgument((timeout >= -1L ? 1 : 0) != 0, (Object)"Timeout must be >= -1");
        if (timeout == 0L) {
            return this.getDAGStatusInternal(statusOptions, timeout);
        }
        long startTime = System.currentTimeMillis();
        if (this.cachedDagStatus != null) {
            dagStatus = this.cachedDagStatus;
            refreshStatus = true;
        } else {
            dagStatus = this.getDAGStatus(statusOptions);
            refreshStatus = false;
        }
        if (dagStatus.getState() == DAGStatus.State.INITING || dagStatus.getState() == DAGStatus.State.SUBMITTED) {
            long timeoutAbsolute = startTime + timeout;
            while (timeout < 0L || timeout > 0L && timeoutAbsolute > System.currentTimeMillis()) {
                long currentStatusPollInterval;
                if (refreshStatus) {
                    dagStatus = this.getDAGStatusInternal(statusOptions, timeout);
                }
                refreshStatus = true;
                if (dagStatus.getState() == DAGStatus.State.RUNNING) {
                    if (dagStatus.getSource() == DagStatusSource.AM) {
                        Preconditions.checkState((timeout > -1L ? 1 : 0) != 0, (Object)"Should not reach here with a timeout of -1. File a bug");
                        return dagStatus;
                    }
                } else if (dagStatus.getState() == DAGStatus.State.SUCCEEDED || dagStatus.getState() == DAGStatus.State.FAILED || dagStatus.getState() == DAGStatus.State.KILLED || dagStatus.getState() == DAGStatus.State.ERROR) {
                    if (dagStatus.getSource() == DagStatusSource.RM) {
                        return this.getDAGStatusInternal(statusOptions, 0L);
                    }
                    return dagStatus;
                }
                if (timeout < 0L) {
                    currentStatusPollInterval = this.statusPollInterval;
                } else {
                    long remainingTimeout = timeoutAbsolute - System.currentTimeMillis();
                    if (remainingTimeout < 0L) {
                        return dagStatus;
                    }
                    currentStatusPollInterval = remainingTimeout < this.statusPollInterval ? remainingTimeout : this.statusPollInterval;
                }
                try {
                    Thread.sleep(currentStatusPollInterval);
                }
                catch (InterruptedException e) {
                    throw new TezException(e);
                }
            }
            if (refreshStatus) {
                return this.getDAGStatus(statusOptions);
            }
            return dagStatus;
        }
        return this.getDAGStatusInternal(statusOptions, timeout);
    }

    private DAGStatus getDAGStatusInternal(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws TezException, IOException {
        block11: {
            DAGStatus dagStatus;
            if (!this.dagCompleted) {
                dagStatus = this.getDAGStatusViaAM(statusOptions, timeout);
                if (!this.dagCompleted) {
                    if (dagStatus != null) {
                        this.cachedDagStatus = dagStatus;
                        return dagStatus;
                    }
                    if (this.cachedDagStatus != null) {
                        return this.cachedDagStatus;
                    }
                }
                if (this.isATSEnabled && this.dagCompleted) {
                    this.switchToTimelineClient();
                }
            }
            if (this.isATSEnabled && this.dagCompleted) {
                try {
                    dagStatus = this.realClient.getDAGStatus(statusOptions);
                    if (dagStatus.isCompleted()) {
                        return dagStatus;
                    }
                }
                catch (ApplicationNotFoundException e) {
                    LOG.info("Failed to fetch DAG data for completed DAG from YARN Timeline - Application not found by YARN", (Throwable)e);
                }
                catch (TezException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.info("DAGStatus fetch failed." + e.getMessage());
                }
            }
        }
        if (this.dagCompleted && this.cachedDagStatus != null && this.cachedDagStatus.isCompleted()) {
            return this.cachedDagStatus;
        }
        return this.getDAGStatusViaRM();
    }

    @Override
    public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions) throws TezException, IOException {
        return this.getDAGStatusInternal(statusOptions, 0L);
    }

    @Override
    public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        VertexStatus vertexStatus;
        block11: {
            if (!this.dagCompleted) {
                vertexStatus = this.getVertexStatusViaAM(vertexName, statusOptions);
                if (!this.dagCompleted) {
                    if (vertexStatus != null) {
                        this.cachedVertexStatus.put(vertexName, vertexStatus);
                        return vertexStatus;
                    }
                    if (this.cachedVertexStatus.containsKey(vertexName)) {
                        return this.cachedVertexStatus.get(vertexName);
                    }
                }
                if (this.isATSEnabled && this.dagCompleted) {
                    this.switchToTimelineClient();
                }
            }
            if (this.isATSEnabled && this.dagCompleted) {
                try {
                    vertexStatus = this.realClient.getVertexStatus(vertexName, statusOptions);
                    if (this.vertexCompletionStates.contains((Object)vertexStatus.getState())) {
                        return vertexStatus;
                    }
                }
                catch (ApplicationNotFoundException e) {
                    LOG.info("Failed to fetch Vertex data for completed DAG from YARN Timeline - Application not found by YARN", (Throwable)e);
                    return null;
                }
                catch (TezException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("ERROR fetching vertex data from Yarn Timeline. " + e.getMessage());
                }
            }
        }
        if (this.cachedVertexStatus.containsKey(vertexName) && this.vertexCompletionStates.contains((Object)(vertexStatus = this.cachedVertexStatus.get(vertexName)).getState())) {
            return vertexStatus;
        }
        return null;
    }

    @Override
    public void tryKillDAG() throws IOException, TezException {
        if (!this.dagCompleted) {
            this.realClient.tryKillDAG();
        } else {
            LOG.info("TryKill for app: " + this.appId + " dag:" + this.dagId + " dag already completed.");
        }
    }

    @Override
    public DAGStatus waitForCompletion() throws IOException, TezException, InterruptedException {
        return this._waitForCompletionWithStatusUpdates(false, EnumSet.noneOf(StatusGetOpts.class));
    }

    @Override
    public DAGStatus waitForCompletionWithStatusUpdates(@Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        return this._waitForCompletionWithStatusUpdates(true, statusGetOpts);
    }

    @Override
    public void close() throws IOException {
        this.realClient.close();
        if (this.frameworkClient != null) {
            this.frameworkClient.stop();
        }
    }

    private DAGStatus getDAGStatusViaAM(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws IOException {
        DAGStatus dagStatus = null;
        try {
            dagStatus = this.realClient.getDAGStatus(statusOptions, timeout);
        }
        catch (DAGNotRunningException e) {
            LOG.info("DAG is no longer running", (Throwable)e);
            this.dagCompleted = true;
        }
        catch (ApplicationNotFoundException e) {
            LOG.info("DAG is no longer running - application not found by YARN", (Throwable)e);
            this.dagCompleted = true;
        }
        catch (TezException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (dagStatus == null && !this.dagCompleted) {
            this.checkAndSetDagCompletionStatus();
        }
        return dagStatus;
    }

    private VertexStatus getVertexStatusViaAM(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException {
        VertexStatus vertexStatus = null;
        try {
            vertexStatus = this.realClient.getVertexStatus(vertexName, statusOptions);
        }
        catch (DAGNotRunningException e) {
            LOG.info("DAG is no longer running", (Throwable)e);
            this.dagCompleted = true;
        }
        catch (ApplicationNotFoundException e) {
            LOG.info("DAG is no longer running - application not found by YARN", (Throwable)e);
            this.dagCompleted = true;
        }
        catch (TezException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (vertexStatus == null && !this.dagCompleted) {
            this.checkAndSetDagCompletionStatus();
        }
        return vertexStatus;
    }

    @VisibleForTesting
    protected DAGStatus getDAGStatusViaRM() throws TezException, IOException {
        DAGProtos.DAGStatusStateProto dagState;
        ApplicationReport appReport;
        if (LOG.isDebugEnabled()) {
            LOG.debug("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId);
        }
        try {
            appReport = this.frameworkClient.getApplicationReport(this.appId);
        }
        catch (ApplicationNotFoundException e) {
            LOG.info("DAG is no longer running - application not found by YARN", (Throwable)e);
            throw new DAGNotRunningException(e);
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        if (appReport == null) {
            throw new TezException("Unknown/Invalid appId: " + this.appId);
        }
        DAGProtos.DAGStatusProto.Builder builder = DAGProtos.DAGStatusProto.newBuilder();
        DAGStatus dagStatus = new DAGStatus(builder, DagStatusSource.RM);
        block2 : switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_SUBMITTED;
                break;
            }
            case RUNNING: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_RUNNING;
                break;
            }
            case FAILED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                break;
            }
            case KILLED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                break;
            }
            case FINISHED: {
                switch (appReport.getFinalApplicationStatus()) {
                    case UNDEFINED: 
                    case FAILED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                        break block2;
                    }
                    case KILLED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                        break block2;
                    }
                    case SUCCEEDED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED;
                        break block2;
                    }
                }
                throw new TezUncheckedException("Encountered unknown final application status from YARN, appState=" + appReport.getYarnApplicationState() + ", finalStatus=" + appReport.getFinalApplicationStatus());
            }
            default: {
                throw new TezUncheckedException("Encountered unknown application state from YARN, appState=" + appReport.getYarnApplicationState());
            }
        }
        builder.setState(dagState);
        if (appReport.getFinalApplicationStatus() == FinalApplicationStatus.FAILED || appReport.getFinalApplicationStatus() == FinalApplicationStatus.KILLED) {
            long startTime = System.currentTimeMillis();
            while ((appReport.getDiagnostics() == null || appReport.getDiagnostics().isEmpty()) && System.currentTimeMillis() - startTime < this.diagnoticsWaitTimeout) {
                try {
                    Thread.sleep(100L);
                    appReport = this.frameworkClient.getApplicationReport(this.appId);
                }
                catch (YarnException e) {
                    throw new TezException(e);
                }
                catch (InterruptedException e) {
                    throw new TezException(e);
                }
            }
        }
        if (appReport.getDiagnostics() != null) {
            builder.addAllDiagnostics(Collections.singleton(appReport.getDiagnostics()));
        }
        return dagStatus;
    }

    private DAGStatus _waitForCompletionWithStatusUpdates(boolean vertexUpdates, @Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        DAGStatus dagStatus;
        boolean initPrinted = false;
        boolean runningPrinted = false;
        double dagProgress = -1.0;
        do {
            dagStatus = this.getDAGStatus(statusGetOpts, 500L);
            if (initPrinted || dagStatus.getState() != DAGStatus.State.INITING && dagStatus.getState() != DAGStatus.State.SUBMITTED) continue;
            initPrinted = true;
            this.log("Waiting for DAG to start running");
        } while (dagStatus.getState() != DAGStatus.State.RUNNING && dagStatus.getState() != DAGStatus.State.SUCCEEDED && dagStatus.getState() != DAGStatus.State.FAILED && dagStatus.getState() != DAGStatus.State.KILLED && dagStatus.getState() != DAGStatus.State.ERROR);
        Set<String> vertexNames = Collections.emptySet();
        while (!dagStatus.isCompleted()) {
            if (!runningPrinted) {
                this.log("DAG initialized: CurrentState=Running");
                runningPrinted = true;
            }
            if (vertexUpdates && vertexNames.isEmpty()) {
                vertexNames = this.getDAGStatus(statusGetOpts).getVertexProgress().keySet();
            }
            dagProgress = this.monitorProgress(vertexNames, dagProgress, null, dagStatus);
            dagStatus = this.getDAGStatus(statusGetOpts, 500L);
        }
        this.monitorProgress(vertexNames, -1.0, statusGetOpts, dagStatus);
        this.log("DAG completed. FinalState=" + (Object)((Object)dagStatus.getState()));
        return dagStatus;
    }

    private double monitorProgress(Set<String> vertexNames, double prevDagProgress, Set<StatusGetOpts> opts, DAGStatus dagStatus) throws IOException, TezException {
        Progress progress = dagStatus.getDAGProgress();
        double dagProgress = prevDagProgress;
        if (progress != null) {
            boolean printIntervalExpired;
            dagProgress = this.getProgress(progress);
            boolean progressChanged = dagProgress > prevDagProgress;
            long currentTimeMillis = System.currentTimeMillis();
            long timeSinceLastPrintStatus = currentTimeMillis - this.lastPrintStatusTimeMillis;
            boolean bl = printIntervalExpired = timeSinceLastPrintStatus > 5000L;
            if (progressChanged || printIntervalExpired) {
                this.lastPrintStatusTimeMillis = currentTimeMillis;
                this.printDAGStatus(vertexNames, opts, dagStatus, progress);
            }
        }
        return dagProgress;
    }

    private void printDAGStatus(Set<String> vertexNames, Set<StatusGetOpts> opts, DAGStatus dagStatus, Progress dagProgress) throws IOException, TezException {
        TezCounters counters;
        boolean displayCounter;
        double vProgressFloat = 0.0;
        this.log("DAG: State: " + (Object)((Object)dagStatus.getState()) + " Progress: " + this.formatter.format(this.getProgress(dagProgress)) + " " + dagProgress);
        boolean bl = displayCounter = opts != null && opts.contains((Object)StatusGetOpts.GET_COUNTERS);
        if (displayCounter && (counters = dagStatus.getDAGCounters()) != null) {
            this.log("DAG Counters:\n" + counters);
        }
        for (String vertex : vertexNames) {
            TezCounters counters2;
            VertexStatus vStatus = this.getVertexStatus(vertex, opts);
            if (vStatus == null) {
                this.log("Could not retrieve status for vertex: " + vertex);
                continue;
            }
            Progress vProgress = vStatus.getProgress();
            if (vProgress != null) {
                vProgressFloat = 0.0;
                if (vProgress.getTotalTaskCount() == 0) {
                    vProgressFloat = 1.0;
                } else if (vProgress.getTotalTaskCount() > 0) {
                    vProgressFloat = this.getProgress(vProgress);
                }
                this.log("\tVertexStatus: VertexName: " + vertex + " Progress: " + this.formatter.format(vProgressFloat) + " " + vProgress);
            }
            if (!displayCounter || (counters2 = vStatus.getVertexCounters()) == null) continue;
            this.log("Vertex Counters for " + vertex + ":\n" + counters2);
        }
    }

    private void checkAndSetDagCompletionStatus() {
        YarnApplicationState appState;
        ApplicationReport appReport = this.realClient.getApplicationReportInternal();
        if (appReport != null && ((appState = appReport.getYarnApplicationState()) == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED)) {
            this.dagCompleted = true;
        }
    }

    private void switchToTimelineClient() throws IOException, TezException {
        this.realClient.close();
        this.realClient = new DAGClientTimelineImpl(this.appId, this.dagId, this.conf, this.frameworkClient, 10000);
        if (LOG.isDebugEnabled()) {
            LOG.debug("dag completed switching to DAGClientTimelineImpl");
        }
    }

    @VisibleForTesting
    public DAGClientInternal getRealClient() {
        return this.realClient;
    }

    private double getProgress(Progress progress) {
        return progress.getTotalTaskCount() == 0 ? 0.0 : (double)progress.getSucceededTaskCount() / (double)progress.getTotalTaskCount();
    }

    private void log(String message) {
        LOG.info(message);
    }
}

