/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;

@InterfaceAudience.Private
public class ReflectionUtils {
    private static final Map<String, Class<?>> CLAZZ_CACHE = new ConcurrentHashMap();
    private static final Class<?>[] parameters = new Class[]{URL.class};
    private static Method sysClassLoaderMethod = null;

    @InterfaceAudience.Private
    public static Class<?> getClazz(String className) {
        Class<?> clazz = CLAZZ_CACHE.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new TezUncheckedException("Unable to load class: " + className, e);
            }
        }
        return clazz;
    }

    private static <T> T getNewInstance(Class<T> clazz) {
        T instance;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new TezUncheckedException("Unable to instantiate class with 0 arguments: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TezUncheckedException("Unable to instantiate class with 0 arguments: " + clazz.getName(), e);
        }
        return instance;
    }

    private static <T> T getNewInstance(Class<T> clazz, Class<?>[] parameterTypes, Object[] parameters) {
        T instance;
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            instance = constructor.newInstance(parameters);
        }
        catch (InstantiationException e) {
            throw new TezUncheckedException("Unable to instantiate class with " + parameters.length + " arguments: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TezUncheckedException("Unable to instantiate class with " + parameters.length + " arguments: " + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new TezUncheckedException("Unable to instantiate class with " + parameters.length + " arguments: " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new TezUncheckedException("Unable to instantiate class with " + parameters.length + " arguments: " + clazz.getName(), e);
        }
        return instance;
    }

    @InterfaceAudience.Private
    public static <T> T createClazzInstance(String className) {
        Class<?> clazz = ReflectionUtils.getClazz(className);
        Object instance = ReflectionUtils.getNewInstance(clazz);
        return (T)instance;
    }

    @InterfaceAudience.Private
    public static <T> T createClazzInstance(String className, Class<?>[] parameterTypes, Object[] parameters) {
        Class<?> clazz = ReflectionUtils.getClazz(className);
        Object instance = ReflectionUtils.getNewInstance(clazz, parameterTypes, parameters);
        return (T)instance;
    }

    @InterfaceAudience.Private
    public static <T> T invokeMethod(Object target, Method method, Object ... args) {
        try {
            return (T)method.invoke(target, args);
        }
        catch (Exception e) {
            throw new TezUncheckedException(e);
        }
    }

    @InterfaceAudience.Private
    public static Method getMethod(Class<?> targetClazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return targetClazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new TezUncheckedException(e);
        }
    }

    @InterfaceAudience.Private
    public static synchronized void addResourcesToClasspath(List<URL> urls) {
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @InterfaceAudience.Private
    public static synchronized void addResourcesToSystemClassLoader(List<URL> urls) {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        if (sysClassLoaderMethod == null) {
            Method method;
            Class<URLClassLoader> sysClass = URLClassLoader.class;
            try {
                method = sysClass.getDeclaredMethod("addURL", parameters);
            }
            catch (SecurityException e) {
                throw new TezUncheckedException("Failed to get handle on method addURL", e);
            }
            catch (NoSuchMethodException e) {
                throw new TezUncheckedException("Failed to get handle on method addURL", e);
            }
            method.setAccessible(true);
            sysClassLoaderMethod = method;
        }
        for (URL url : urls) {
            try {
                sysClassLoaderMethod.invoke((Object)sysLoader, url);
            }
            catch (IllegalArgumentException e) {
                throw new TezUncheckedException("Failed to invoke addURL for rsrc: " + url, e);
            }
            catch (IllegalAccessException e) {
                throw new TezUncheckedException("Failed to invoke addURL for rsrc: " + url, e);
            }
            catch (InvocationTargetException e) {
                throw new TezUncheckedException("Failed to invoke addURL for rsrc: " + url, e);
            }
        }
    }
}

