/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ClassUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog(VersionInfo.class);
    private final Properties info;
    private final String component;
    private static final String VERSION = "version";
    private static final String REVISION = "revision";
    private static final String BUILD_TIME = "buildtime";
    private static final String SCM_URL = "scmurl";
    public static final String UNKNOWN = "Unknown";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionInfo(String component) {
        this.component = component;
        this.info = new Properties();
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionInfoFile);
            if (is == null) {
                throw new IOException("Resource not found");
            }
            this.info.load(is);
        }
        catch (IOException ex) {
            try {
                LogFactory.getLog(this.getClass()).warn((Object)("Could not read '" + versionInfoFile + "', " + ex.toString()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(is);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)is);
        }
        IOUtils.closeStream((Closeable)is);
    }

    public String getVersion() {
        return this.info.getProperty(VERSION, UNKNOWN);
    }

    public String getBuildTime() {
        return this.info.getProperty(BUILD_TIME, UNKNOWN);
    }

    public String getRevision() {
        return this.info.getProperty(REVISION, UNKNOWN);
    }

    public String getSCMURL() {
        return this.info.getProperty(SCM_URL, UNKNOWN);
    }

    public String toString() {
        return "[ component=" + this.component + ", version=" + this.getVersion() + ", revision=" + this.getRevision() + ", SCM-URL=" + this.getSCMURL() + ", buildTIme=" + this.getBuildTime() + " ]";
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Invalid no. of args. Usage: VersionInfo <component-name>");
            System.exit(-1);
        }
        VersionInfo versionInfo = new VersionInfo(args[0]);
        System.out.println("VersionInfo: " + versionInfo.toString());
        System.out.println("This command was run using " + ClassUtil.findContainingJar(VersionInfo.class));
    }
}

