/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Private
public class DAGClientRPCImpl
extends DAGClient {
    private static final Log LOG = LogFactory.getLog(DAGClientRPCImpl.class);
    private static final long SLEEP_FOR_COMPLETION = 500L;
    private static final long PRINT_STATUS_INTERVAL_MILLIS = 5000L;
    private final DecimalFormat formatter = new DecimalFormat("###.##%");
    private final ApplicationId appId;
    private final String dagId;
    private final TezConfiguration conf;
    private long lastPrintStatusTimeMillis;
    @VisibleForTesting
    ApplicationReport appReport;
    private final FrameworkClient frameworkClient;
    @VisibleForTesting
    DAGClientAMProtocolBlockingPB proxy = null;

    public DAGClientRPCImpl(ApplicationId appId, String dagId, TezConfiguration conf, @Nullable FrameworkClient frameworkClient) {
        this.appId = appId;
        this.dagId = dagId;
        this.conf = conf;
        if (frameworkClient != null && conf.getBoolean("tez.local.mode", false)) {
            this.frameworkClient = frameworkClient;
        } else {
            this.frameworkClient = FrameworkClient.createFrameworkClient(conf);
            this.frameworkClient.init(conf, new YarnConfiguration((Configuration)conf));
            this.frameworkClient.start();
        }
        this.appReport = null;
    }

    @Override
    public String getExecutionContext() {
        return new String("Executing on YARN cluster with App id " + this.appId);
    }

    @Override
    public DAGStatus getDAGStatus(Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (this.createAMProxyIfNeeded()) {
            try {
                return this.getDAGStatusViaAM(statusOptions);
            }
            catch (TezException e) {
                this.resetProxy(e);
            }
        }
        return this.getDAGStatusViaRM();
    }

    @Override
    public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (this.createAMProxyIfNeeded()) {
            try {
                return this.getVertexStatusViaAM(vertexName, statusOptions);
            }
            catch (TezException e) {
                this.resetProxy(e);
            }
        }
        return null;
    }

    @Override
    public void tryKillDAG() throws TezException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("TryKill for app: " + this.appId + " dag:" + this.dagId));
        }
        if (this.createAMProxyIfNeeded()) {
            DAGClientAMProtocolRPC.TryKillDAGRequestProto requestProto = DAGClientAMProtocolRPC.TryKillDAGRequestProto.newBuilder().setDagId(this.dagId).build();
            try {
                this.proxy.tryKillDAG(null, requestProto);
            }
            catch (ServiceException e) {
                this.resetProxy((Exception)((Object)e));
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
        if (this.frameworkClient != null) {
            this.frameworkClient.stop();
        }
    }

    @Override
    protected ApplicationReport getApplicationReportInternal() {
        return this.appReport;
    }

    void resetProxy(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resetting AM proxy for app: " + this.appId + " dag:" + this.dagId + " due to exception :"), (Throwable)e);
        }
        this.proxy = null;
    }

    DAGStatus getDAGStatusViaAM(Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId));
        }
        DAGClientAMProtocolRPC.GetDAGStatusRequestProto.Builder requestProtoBuilder = DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagId);
        if (statusOptions != null) {
            requestProtoBuilder.addAllStatusOptions(DagTypeConverters.convertStatusGetOptsToProto(statusOptions));
        }
        try {
            return new DAGStatus(this.proxy.getDAGStatus(null, requestProtoBuilder.build()).getDagStatus());
        }
        catch (ServiceException e) {
            throw new TezException(e);
        }
    }

    DAGStatus getDAGStatusViaRM() throws TezException, IOException {
        DAGProtos.DAGStatusStateProto dagState;
        ApplicationReport appReport;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId));
        }
        try {
            appReport = this.frameworkClient.getApplicationReport(this.appId);
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        if (appReport == null) {
            throw new TezException("Unknown/Invalid appId: " + this.appId);
        }
        DAGProtos.DAGStatusProto.Builder builder = DAGProtos.DAGStatusProto.newBuilder();
        DAGStatus dagStatus = new DAGStatus(builder);
        block1 : switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_SUBMITTED;
                break;
            }
            case RUNNING: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_RUNNING;
                break;
            }
            case FAILED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                break;
            }
            case KILLED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                break;
            }
            case FINISHED: {
                switch (appReport.getFinalApplicationStatus()) {
                    case UNDEFINED: 
                    case FAILED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                        break block1;
                    }
                    case KILLED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                        break block1;
                    }
                    case SUCCEEDED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED;
                        break block1;
                    }
                }
                throw new TezUncheckedException("Encountered unknown final application status from YARN, appState=" + appReport.getYarnApplicationState() + ", finalStatus=" + appReport.getFinalApplicationStatus());
            }
            default: {
                throw new TezUncheckedException("Encountered unknown application state from YARN, appState=" + appReport.getYarnApplicationState());
            }
        }
        builder.setState(dagState);
        if (appReport.getDiagnostics() != null) {
            builder.addAllDiagnostics(Collections.singleton(appReport.getDiagnostics()));
        }
        return dagStatus;
    }

    VertexStatus getVertexStatusViaAM(String vertexName, Set<StatusGetOpts> statusOptions) throws TezException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetVertexStatus via AM for app: " + this.appId + " dag: " + this.dagId + " vertex: " + vertexName));
        }
        DAGClientAMProtocolRPC.GetVertexStatusRequestProto.Builder requestProtoBuilder = DAGClientAMProtocolRPC.GetVertexStatusRequestProto.newBuilder().setDagId(this.dagId).setVertexName(vertexName);
        if (statusOptions != null) {
            requestProtoBuilder.addAllStatusOptions(DagTypeConverters.convertStatusGetOptsToProto(statusOptions));
        }
        try {
            return new VertexStatus(this.proxy.getVertexStatus(null, requestProtoBuilder.build()).getVertexStatus());
        }
        catch (ServiceException e) {
            throw new TezException(e);
        }
    }

    ApplicationReport getAppReport() throws IOException, TezException {
        try {
            ApplicationReport appReport = this.frameworkClient.getApplicationReport(this.appId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("App: " + this.appId + " in state: " + appReport.getYarnApplicationState()));
            }
            return appReport;
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
    }

    boolean createAMProxyIfNeeded() throws IOException, TezException {
        if (this.proxy != null) {
            return true;
        }
        this.appReport = this.getAppReport();
        if (this.appReport == null) {
            return false;
        }
        YarnApplicationState appState = this.appReport.getYarnApplicationState();
        if (appState != YarnApplicationState.RUNNING) {
            return false;
        }
        if (this.appReport.getHost() == null || this.appReport.getHost().equals("N/A") || this.appReport.getRpcPort() == 0) {
            return false;
        }
        this.proxy = TezClientUtils.getAMProxy(this.conf, this.appReport.getHost(), this.appReport.getRpcPort(), this.appReport.getClientToAMToken());
        return true;
    }

    @Override
    public DAGStatus waitForCompletion() throws IOException, TezException, InterruptedException {
        return this._waitForCompletionWithStatusUpdates(false, EnumSet.noneOf(StatusGetOpts.class));
    }

    @Override
    public DAGStatus waitForCompletionWithStatusUpdates(@Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        return this._waitForCompletionWithStatusUpdates(true, statusGetOpts);
    }

    private DAGStatus _waitForCompletionWithStatusUpdates(boolean vertexUpdates, @Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        DAGStatus dagStatus;
        boolean initPrinted = false;
        boolean runningPrinted = false;
        double dagProgress = -1.0;
        while (true) {
            dagStatus = this.getDAGStatus(statusGetOpts);
            if (!(initPrinted || dagStatus.getState() != DAGStatus.State.INITING && dagStatus.getState() != DAGStatus.State.SUBMITTED)) {
                initPrinted = true;
                this.log("Waiting for DAG to start running");
            }
            if (dagStatus.getState() == DAGStatus.State.RUNNING || dagStatus.getState() == DAGStatus.State.SUCCEEDED || dagStatus.getState() == DAGStatus.State.FAILED || dagStatus.getState() == DAGStatus.State.KILLED || dagStatus.getState() == DAGStatus.State.ERROR) break;
            Thread.sleep(500L);
        }
        Set<String> vertexNames = Collections.emptySet();
        while (!dagStatus.isCompleted()) {
            if (!runningPrinted) {
                this.log("DAG initialized: CurrentState=Running");
                runningPrinted = true;
            }
            if (vertexUpdates && vertexNames.isEmpty()) {
                vertexNames = this.getDAGStatus(statusGetOpts).getVertexProgress().keySet();
            }
            dagProgress = this.monitorProgress(vertexNames, dagProgress, null, dagStatus);
            Thread.sleep(500L);
            dagStatus = this.getDAGStatus(statusGetOpts);
        }
        this.monitorProgress(vertexNames, -1.0, statusGetOpts, dagStatus);
        this.log("DAG completed. FinalState=" + (Object)((Object)dagStatus.getState()));
        return dagStatus;
    }

    private double monitorProgress(Set<String> vertexNames, double prevDagProgress, Set<StatusGetOpts> opts, DAGStatus dagStatus) throws IOException, TezException {
        Progress progress = dagStatus.getDAGProgress();
        double dagProgress = prevDagProgress;
        if (progress != null) {
            boolean printIntervalExpired;
            dagProgress = this.getProgress(progress);
            boolean progressChanged = dagProgress > prevDagProgress;
            long currentTimeMillis = System.currentTimeMillis();
            long timeSinceLastPrintStatus = currentTimeMillis - this.lastPrintStatusTimeMillis;
            boolean bl = printIntervalExpired = timeSinceLastPrintStatus > 5000L;
            if (progressChanged || printIntervalExpired) {
                this.lastPrintStatusTimeMillis = currentTimeMillis;
                this.printDAGStatus(vertexNames, opts, dagStatus, progress);
            }
        }
        return dagProgress;
    }

    private void printDAGStatus(Set<String> vertexNames, Set<StatusGetOpts> opts, DAGStatus dagStatus, Progress dagProgress) throws IOException, TezException {
        TezCounters counters;
        boolean displayCounter;
        double vProgressFloat = 0.0;
        this.log("DAG: State: " + (Object)((Object)dagStatus.getState()) + " Progress: " + this.formatter.format(this.getProgress(dagProgress)) + " " + dagProgress);
        boolean bl = displayCounter = opts != null ? opts.contains((Object)StatusGetOpts.GET_COUNTERS) : false;
        if (displayCounter && (counters = dagStatus.getDAGCounters()) != null) {
            this.log("DAG Counters:\n" + counters);
        }
        for (String vertex : vertexNames) {
            TezCounters counters2;
            VertexStatus vStatus = this.getVertexStatus(vertex, opts);
            if (vStatus == null) {
                this.log("Could not retrieve status for vertex: " + vertex);
                continue;
            }
            Progress vProgress = vStatus.getProgress();
            if (vProgress != null) {
                vProgressFloat = 0.0;
                if (vProgress.getTotalTaskCount() == 0) {
                    vProgressFloat = 1.0;
                } else if (vProgress.getTotalTaskCount() > 0) {
                    vProgressFloat = this.getProgress(vProgress);
                }
                this.log("VertexStatus: VertexName: " + vertex + " Progress: " + this.formatter.format(vProgressFloat) + " " + vProgress);
            }
            if (!displayCounter || (counters2 = vStatus.getVertexCounters()) == null) continue;
            this.log("Vertex Counters for " + vertex + ":\n" + counters2);
        }
    }

    private double getProgress(Progress progress) {
        return progress.getTotalTaskCount() == 0 ? 0.0 : (double)progress.getSucceededTaskCount() / (double)progress.getTotalTaskCount();
    }

    private void log(String message) {
        LOG.info((Object)message);
    }
}

