/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.records.DAGProtos;

public class DAGStatus {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    DAGProtos.DAGStatusProtoOrBuilder proxy = null;
    Progress progress = null;
    Map<String, Progress> vertexProgress = null;
    TezCounters dagCounters = null;
    AtomicBoolean countersInitialized = new AtomicBoolean(false);

    public DAGStatus(DAGProtos.DAGStatusProtoOrBuilder proxy) {
        this.proxy = proxy;
    }

    public State getState() {
        switch (this.proxy.getState()) {
            case DAG_SUBMITTED: {
                return State.SUBMITTED;
            }
            case DAG_INITING: 
            case DAG_TERMINATING: 
            case DAG_RUNNING: {
                return State.RUNNING;
            }
            case DAG_SUCCEEDED: {
                return State.SUCCEEDED;
            }
            case DAG_FAILED: {
                return State.FAILED;
            }
            case DAG_KILLED: {
                return State.KILLED;
            }
            case DAG_ERROR: {
                return State.ERROR;
            }
        }
        throw new TezUncheckedException("Unsupported value for DAGStatus.State : " + (Object)((Object)this.proxy.getState()));
    }

    public boolean isCompleted() {
        State state = this.getState();
        return state == State.SUCCEEDED || state == State.FAILED || state == State.KILLED || state == State.ERROR;
    }

    public List<String> getDiagnostics() {
        return this.proxy.getDiagnosticsList();
    }

    public Progress getDAGProgress() {
        if (this.progress == null && this.proxy.hasDAGProgress()) {
            this.progress = new Progress(this.proxy.getDAGProgress());
        }
        return this.progress;
    }

    public Map<String, Progress> getVertexProgress() {
        if (this.vertexProgress == null && this.proxy.getVertexProgressList() != null) {
            List<DAGProtos.StringProgressPairProto> kvList = this.proxy.getVertexProgressList();
            this.vertexProgress = new HashMap<String, Progress>(kvList.size());
            for (DAGProtos.StringProgressPairProto kv : kvList) {
                this.vertexProgress.put(kv.getKey(), new Progress(kv.getProgress()));
            }
        }
        return this.vertexProgress;
    }

    public TezCounters getDAGCounters() {
        if (this.countersInitialized.get()) {
            return this.dagCounters;
        }
        if (this.proxy.hasDagCounters()) {
            this.dagCounters = DagTypeConverters.convertTezCountersFromProto(this.proxy.getDagCounters());
        }
        this.countersInitialized.set(true);
        return this.dagCounters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=" + (Object)((Object)this.getState()) + ", progress=" + this.getDAGProgress() + ", diagnostics=" + StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()) + ", counters=" + (this.dagCounters == null ? "null" : this.dagCounters.toString()));
        return sb.toString();
    }

    public static enum State {
        SUBMITTED,
        INITING,
        RUNNING,
        SUCCEEDED,
        KILLED,
        FAILED,
        ERROR;

    }
}

