/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;

public class AMConfiguration {
    private final Path stagingDir;
    private final String queueName;
    private final Map<String, String> env;
    private final Map<String, LocalResource> localResources;
    private final TezConfiguration amConf;
    private final Credentials credentials;

    public AMConfiguration(Map<String, String> env, Map<String, LocalResource> localResources, TezConfiguration conf, Credentials credentials) {
        this.amConf = conf != null ? conf : new TezConfiguration();
        this.queueName = this.amConf.get("tez.queue.name");
        this.env = env != null ? env : new HashMap<String, String>(0);
        this.localResources = localResources;
        String stagingDirStr = this.amConf.get("tez.staging-dir");
        if (stagingDirStr == null || stagingDirStr.isEmpty()) {
            throw new TezUncheckedException("Staging directory for AM resources not specified in config, property=tez.staging-dir");
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)this.amConf);
            this.stagingDir = fs.resolvePath(new Path(stagingDirStr));
        }
        catch (IOException e) {
            throw new TezUncheckedException(e);
        }
        this.credentials = credentials;
    }

    public Path getStagingDir() {
        return this.stagingDir;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, LocalResource> getLocalResources() {
        return this.localResources;
    }

    public TezConfiguration getAMConf() {
        return this.amConf;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void isCompatible(AMConfiguration other) {
    }
}

