/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Public
public class VertexStatus {
    DAGProtos.VertexStatusProtoOrBuilder proxy = null;
    Progress progress = null;
    TezCounters vertexCounters = null;
    private AtomicBoolean countersInitialized = new AtomicBoolean(false);

    public VertexStatus(DAGProtos.VertexStatusProtoOrBuilder proxy) {
        this.proxy = proxy;
    }

    public String getId() {
        return this.proxy.getId();
    }

    public State getState() {
        return VertexStatus.getState(this.proxy.getState());
    }

    @VisibleForTesting
    static State getState(DAGProtos.VertexStatusStateProto stateProto) {
        switch (stateProto) {
            case VERTEX_NEW: {
                return State.NEW;
            }
            case VERTEX_INITIALIZING: {
                return State.INITIALIZING;
            }
            case VERTEX_INITED: {
                return State.INITED;
            }
            case VERTEX_RUNNING: {
                return State.RUNNING;
            }
            case VERTEX_COMMITTING: {
                return State.COMMITTING;
            }
            case VERTEX_SUCCEEDED: {
                return State.SUCCEEDED;
            }
            case VERTEX_FAILED: {
                return State.FAILED;
            }
            case VERTEX_KILLED: {
                return State.KILLED;
            }
            case VERTEX_ERROR: {
                return State.ERROR;
            }
            case VERTEX_TERMINATING: {
                return State.TERMINATING;
            }
        }
        throw new TezUncheckedException("Unsupported value for VertexStatus.State : " + (Object)((Object)stateProto));
    }

    public List<String> getDiagnostics() {
        return this.proxy.getDiagnosticsList();
    }

    public Progress getProgress() {
        if (this.progress == null && this.proxy.hasProgress()) {
            this.progress = new Progress(this.proxy.getProgress());
        }
        return this.progress;
    }

    public TezCounters getVertexCounters() {
        if (this.countersInitialized.get()) {
            return this.vertexCounters;
        }
        if (this.proxy.hasVertexCounters()) {
            this.vertexCounters = DagTypeConverters.convertTezCountersFromProto(this.proxy.getVertexCounters());
        }
        this.countersInitialized.set(true);
        return this.vertexCounters;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VertexStatus) {
            VertexStatus other = (VertexStatus)obj;
            return this.getState().equals((Object)other.getState()) && this.getDiagnostics().equals(other.getDiagnostics()) && this.getProgress().equals(other.getProgress()) && (this.getVertexCounters() == null && other.getVertexCounters() == null || this.getVertexCounters().equals(other.getVertexCounters()));
        }
        return false;
    }

    public int hashCode() {
        int prime = 46021;
        int result = 1;
        result = 46021 + this.getState().hashCode();
        List<String> diagnostics = this.getDiagnostics();
        Progress vProgress = this.getProgress();
        TezCounters counters = this.getVertexCounters();
        result = 46021 * result + (diagnostics == null ? 0 : diagnostics.hashCode());
        result = 46021 * result + (vProgress == null ? 0 : vProgress.hashCode());
        result = 46021 * result + (counters == null ? 0 : counters.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=" + (Object)((Object)this.getState()) + ", progress=" + this.getProgress() + ", counters=" + (this.getVertexCounters() == null ? "null" : this.getVertexCounters().toString()));
        return sb.toString();
    }

    public static enum State {
        NEW,
        INITIALIZING,
        INITED,
        RUNNING,
        COMMITTING,
        SUCCEEDED,
        FAILED,
        KILLED,
        ERROR,
        TERMINATING;

    }
}

