/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.Inflater;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;

@InterfaceAudience.Private
public class DagTypeConverters {
    public static DAGProtos.PlanLocalResourceVisibility convertToDAGPlan(LocalResourceVisibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return DAGProtos.PlanLocalResourceVisibility.PUBLIC;
            }
            case PRIVATE: {
                return DAGProtos.PlanLocalResourceVisibility.PRIVATE;
            }
            case APPLICATION: {
                return DAGProtos.PlanLocalResourceVisibility.APPLICATION;
            }
        }
        throw new RuntimeException("unknown 'visibility': " + visibility);
    }

    public static List<DAGProtos.PlanLocalResource> convertToDAGPlan(Map<String, LocalResource> lrs) {
        ArrayList planLrs = Lists.newArrayListWithCapacity((int)lrs.size());
        for (Map.Entry<String, LocalResource> entry : lrs.entrySet()) {
            DAGProtos.PlanLocalResource.Builder localResourcesBuilder = DAGProtos.PlanLocalResource.newBuilder();
            String key = entry.getKey();
            LocalResource lr = entry.getValue();
            localResourcesBuilder.setName(key);
            localResourcesBuilder.setUri(DagTypeConverters.convertToDAGPlan(lr.getResource()));
            localResourcesBuilder.setSize(lr.getSize());
            localResourcesBuilder.setTimeStamp(lr.getTimestamp());
            localResourcesBuilder.setType(DagTypeConverters.convertToDAGPlan(lr.getType()));
            localResourcesBuilder.setVisibility(DagTypeConverters.convertToDAGPlan(lr.getVisibility()));
            if (lr.getType() == LocalResourceType.PATTERN) {
                if (lr.getPattern() == null || lr.getPattern().isEmpty()) {
                    throw new TezUncheckedException("LocalResource type set to pattern but pattern is null or empty");
                }
                localResourcesBuilder.setPattern(lr.getPattern());
            }
            planLrs.add(localResourcesBuilder.build());
        }
        return planLrs;
    }

    public static LocalResourceVisibility convertFromDAGPlan(DAGProtos.PlanLocalResourceVisibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return LocalResourceVisibility.PUBLIC;
            }
            case PRIVATE: {
                return LocalResourceVisibility.PRIVATE;
            }
            case APPLICATION: {
                return LocalResourceVisibility.APPLICATION;
            }
        }
        throw new RuntimeException("unknown 'visibility': " + (Object)((Object)visibility));
    }

    public static DAGProtos.PlanEdgeDataSourceType convertToDAGPlan(EdgeProperty.DataSourceType sourceType) {
        switch (sourceType) {
            case PERSISTED: {
                return DAGProtos.PlanEdgeDataSourceType.PERSISTED;
            }
            case PERSISTED_RELIABLE: {
                return DAGProtos.PlanEdgeDataSourceType.PERSISTED_RELIABLE;
            }
            case EPHEMERAL: {
                return DAGProtos.PlanEdgeDataSourceType.EPHEMERAL;
            }
        }
        throw new RuntimeException("unknown 'dataSourceType': " + (Object)((Object)sourceType));
    }

    public static EdgeProperty.DataSourceType convertFromDAGPlan(DAGProtos.PlanEdgeDataSourceType sourceType) {
        switch (sourceType) {
            case PERSISTED: {
                return EdgeProperty.DataSourceType.PERSISTED;
            }
            case PERSISTED_RELIABLE: {
                return EdgeProperty.DataSourceType.PERSISTED_RELIABLE;
            }
            case EPHEMERAL: {
                return EdgeProperty.DataSourceType.EPHEMERAL;
            }
        }
        throw new RuntimeException("unknown 'dataSourceType': " + (Object)((Object)sourceType));
    }

    public static DAGProtos.PlanEdgeDataMovementType convertToDAGPlan(EdgeProperty.DataMovementType type) {
        switch (type) {
            case ONE_TO_ONE: {
                return DAGProtos.PlanEdgeDataMovementType.ONE_TO_ONE;
            }
            case BROADCAST: {
                return DAGProtos.PlanEdgeDataMovementType.BROADCAST;
            }
            case SCATTER_GATHER: {
                return DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER;
            }
            case CUSTOM: {
                return DAGProtos.PlanEdgeDataMovementType.CUSTOM;
            }
        }
        throw new RuntimeException("unknown 'dataMovementType': " + (Object)((Object)type));
    }

    public static EdgeProperty.DataMovementType convertFromDAGPlan(DAGProtos.PlanEdgeDataMovementType type) {
        switch (type) {
            case ONE_TO_ONE: {
                return EdgeProperty.DataMovementType.ONE_TO_ONE;
            }
            case BROADCAST: {
                return EdgeProperty.DataMovementType.BROADCAST;
            }
            case SCATTER_GATHER: {
                return EdgeProperty.DataMovementType.SCATTER_GATHER;
            }
            case CUSTOM: {
                return EdgeProperty.DataMovementType.CUSTOM;
            }
        }
        throw new IllegalArgumentException("unknown 'dataMovementType': " + (Object)((Object)type));
    }

    public static DAGProtos.PlanEdgeSchedulingType convertToDAGPlan(EdgeProperty.SchedulingType type) {
        switch (type) {
            case SEQUENTIAL: {
                return DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL;
            }
            case CONCURRENT: {
                return DAGProtos.PlanEdgeSchedulingType.CONCURRENT;
            }
        }
        throw new RuntimeException("unknown 'SchedulingType': " + (Object)((Object)type));
    }

    public static EdgeProperty.SchedulingType convertFromDAGPlan(DAGProtos.PlanEdgeSchedulingType type) {
        switch (type) {
            case SEQUENTIAL: {
                return EdgeProperty.SchedulingType.SEQUENTIAL;
            }
            case CONCURRENT: {
                return EdgeProperty.SchedulingType.CONCURRENT;
            }
        }
        throw new IllegalArgumentException("unknown 'SchedulingType': " + (Object)((Object)type));
    }

    public static DAGProtos.PlanLocalResourceType convertToDAGPlan(LocalResourceType type) {
        switch (type) {
            case ARCHIVE: {
                return DAGProtos.PlanLocalResourceType.ARCHIVE;
            }
            case FILE: {
                return DAGProtos.PlanLocalResourceType.FILE;
            }
            case PATTERN: {
                return DAGProtos.PlanLocalResourceType.PATTERN;
            }
        }
        throw new IllegalArgumentException("unknown 'type': " + type);
    }

    public static LocalResourceType convertFromDAGPlan(DAGProtos.PlanLocalResourceType type) {
        switch (type) {
            case ARCHIVE: {
                return LocalResourceType.ARCHIVE;
            }
            case FILE: {
                return LocalResourceType.FILE;
            }
            case PATTERN: {
                return LocalResourceType.PATTERN;
            }
        }
        throw new IllegalArgumentException("unknown 'type': " + (Object)((Object)type));
    }

    public static VertexLocationHint convertFromDAGPlan(List<DAGProtos.PlanTaskLocationHint> locationHints) {
        ArrayList<TaskLocationHint> outputList = new ArrayList<TaskLocationHint>();
        for (DAGProtos.PlanTaskLocationHint inputHint : locationHints) {
            TaskLocationHint outputHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(inputHint.getHostList()), new HashSet<String>(inputHint.getRackList()));
            outputList.add(outputHint);
        }
        return VertexLocationHint.create(outputList);
    }

    public static String convertToDAGPlan(URL resource) {
        Path p;
        try {
            p = ConverterUtils.getPathFromYarnURL((URL)resource);
        }
        catch (URISyntaxException e) {
            throw new TezUncheckedException("Unable to translate resource: " + resource + " to Path");
        }
        String urlString = p.toString();
        return urlString;
    }

    public static URL convertToYarnURL(String pathString) {
        Path path = new Path(pathString);
        return ConverterUtils.getYarnUrlFromPath((Path)path);
    }

    public static Map<String, LocalResource> createLocalResourceMapFromDAGPlan(List<DAGProtos.PlanLocalResource> localResourcesList) {
        HashMap<String, LocalResource> map = new HashMap<String, LocalResource>();
        for (DAGProtos.PlanLocalResource res : localResourcesList) {
            LocalResourcePBImpl r = new LocalResourcePBImpl();
            if (res.hasPattern()) {
                r.setPattern(res.getPattern());
            }
            r.setResource(DagTypeConverters.convertToYarnURL(res.getUri()));
            r.setSize(res.getSize());
            r.setTimestamp(res.getTimeStamp());
            r.setType(DagTypeConverters.convertFromDAGPlan(res.getType()));
            r.setVisibility(DagTypeConverters.convertFromDAGPlan(res.getVisibility()));
            map.put(res.getName(), (LocalResource)r);
        }
        return map;
    }

    public static Map<String, String> createEnvironmentMapFromDAGPlan(List<DAGProtos.PlanKeyValuePair> environmentSettingList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (DAGProtos.PlanKeyValuePair setting : environmentSettingList) {
            map.put(setting.getKey(), setting.getValue());
        }
        return map;
    }

    public static Map<String, DAGProtos.EdgePlan> createEdgePlanMapFromDAGPlan(List<DAGProtos.EdgePlan> edgeList) {
        HashMap<String, DAGProtos.EdgePlan> edgePlanMap = new HashMap<String, DAGProtos.EdgePlan>();
        for (DAGProtos.EdgePlan edgePlanItem : edgeList) {
            edgePlanMap.put(edgePlanItem.getId(), edgePlanItem);
        }
        return edgePlanMap;
    }

    public static DAGProtos.PlanEdgeProperty convertToProto(EdgeProperty prop) {
        DAGProtos.PlanEdgeProperty.Builder edgePropBuilder = DAGProtos.PlanEdgeProperty.newBuilder();
        edgePropBuilder.setDataMovementType(DagTypeConverters.convertToDAGPlan(prop.getDataMovementType()));
        edgePropBuilder.setDataSourceType(DagTypeConverters.convertToDAGPlan(prop.getDataSourceType()));
        edgePropBuilder.setSchedulingType(DagTypeConverters.convertToDAGPlan(prop.getSchedulingType()));
        edgePropBuilder.setEdgeSource(DagTypeConverters.convertToDAGPlan(prop.getEdgeSource()));
        edgePropBuilder.setEdgeDestination(DagTypeConverters.convertToDAGPlan(prop.getEdgeDestination()));
        if (prop.getEdgeManagerDescriptor() != null) {
            edgePropBuilder.setEdgeManager(DagTypeConverters.convertToDAGPlan(prop.getEdgeManagerDescriptor()));
        }
        return edgePropBuilder.build();
    }

    public static EdgeProperty convertFromProto(DAGProtos.PlanEdgeProperty edge) {
        return EdgeProperty.create(edge.hasEdgeManager() ? DagTypeConverters.convertEdgeManagerPluginDescriptorFromDAGPlan(edge.getEdgeManager()) : null, DagTypeConverters.convertFromDAGPlan(edge.getDataMovementType()), DagTypeConverters.convertFromDAGPlan(edge.getDataSourceType()), DagTypeConverters.convertFromDAGPlan(edge.getSchedulingType()), DagTypeConverters.convertOutputDescriptorFromDAGPlan(edge.getEdgeSource()), DagTypeConverters.convertInputDescriptorFromDAGPlan(edge.getEdgeDestination()));
    }

    public static EdgeProperty createEdgePropertyMapFromDAGPlan(DAGProtos.EdgePlan edge) {
        if (edge.getDataMovementType() == DAGProtos.PlanEdgeDataMovementType.CUSTOM) {
            return EdgeProperty.create(edge.hasEdgeManager() ? DagTypeConverters.convertEdgeManagerPluginDescriptorFromDAGPlan(edge.getEdgeManager()) : null, DagTypeConverters.convertFromDAGPlan(edge.getDataSourceType()), DagTypeConverters.convertFromDAGPlan(edge.getSchedulingType()), DagTypeConverters.convertOutputDescriptorFromDAGPlan(edge.getEdgeSource()), DagTypeConverters.convertInputDescriptorFromDAGPlan(edge.getEdgeDestination()));
        }
        return EdgeProperty.create(DagTypeConverters.convertFromDAGPlan(edge.getDataMovementType()), DagTypeConverters.convertFromDAGPlan(edge.getDataSourceType()), DagTypeConverters.convertFromDAGPlan(edge.getSchedulingType()), DagTypeConverters.convertOutputDescriptorFromDAGPlan(edge.getEdgeSource()), DagTypeConverters.convertInputDescriptorFromDAGPlan(edge.getEdgeDestination()));
    }

    public static Resource createResourceRequestFromTaskConfig(DAGProtos.PlanTaskConfiguration taskConfig) {
        return Resource.newInstance((int)taskConfig.getMemoryMb(), (int)taskConfig.getVirtualCores());
    }

    public static Map<String, String> convertConfFromProto(DAGProtos.ConfigurationProto confProto) {
        List<DAGProtos.PlanKeyValuePair> settingList = confProto.getConfKeyValuesList();
        HashMap<String, String> map = new HashMap<String, String>();
        for (DAGProtos.PlanKeyValuePair setting : settingList) {
            map.put(setting.getKey(), setting.getValue());
        }
        return map;
    }

    public static DAGProtos.TezEntityDescriptorProto convertToDAGPlan(EntityDescriptor<?> descriptor) {
        DAGProtos.TezEntityDescriptorProto.Builder builder = DAGProtos.TezEntityDescriptorProto.newBuilder();
        builder.setClassName(descriptor.getClassName());
        UserPayload userPayload = descriptor.getUserPayload();
        if (userPayload != null) {
            DAGProtos.TezUserPayloadProto.Builder payloadBuilder = DAGProtos.TezUserPayloadProto.newBuilder();
            if (userPayload.hasPayload()) {
                payloadBuilder.setUserPayload(ByteString.copyFrom((ByteBuffer)userPayload.getPayload()));
                payloadBuilder.setVersion(userPayload.getVersion());
            }
            builder.setTezUserPayload(payloadBuilder.build());
        }
        if (descriptor.getHistoryText() != null) {
            try {
                builder.setHistoryText(TezCommonUtils.compressByteArrayToByteString(descriptor.getHistoryText().getBytes("UTF-8")));
            }
            catch (IOException e) {
                throw new TezUncheckedException(e);
            }
        }
        return builder.build();
    }

    public static String getHistoryTextFromProto(DAGProtos.TezEntityDescriptorProto proto, Inflater inflater) {
        if (!proto.hasHistoryText()) {
            return null;
        }
        try {
            return new String(TezCommonUtils.decompressByteStringToByteArray(proto.getHistoryText(), inflater), "UTF-8");
        }
        catch (IOException e) {
            throw new TezUncheckedException(e);
        }
    }

    public static DAGProtos.RootInputLeafOutputProto convertToDAGPlan(RootInputLeafOutput<? extends EntityDescriptor<?>, ? extends EntityDescriptor<?>> rootIO) {
        DAGProtos.RootInputLeafOutputProto.Builder builder = DAGProtos.RootInputLeafOutputProto.newBuilder();
        builder.setName(rootIO.getName());
        builder.setIODescriptor(DagTypeConverters.convertToDAGPlan(rootIO.getIODescriptor()));
        if (rootIO.getControllerDescriptor() != null) {
            builder.setControllerDescriptor(DagTypeConverters.convertToDAGPlan(rootIO.getControllerDescriptor()));
        }
        return builder.build();
    }

    private static UserPayload convertTezUserPayloadFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        UserPayload userPayload = null;
        if (proto.hasTezUserPayload()) {
            userPayload = proto.getTezUserPayload().hasUserPayload() ? UserPayload.create(proto.getTezUserPayload().getUserPayload().asReadOnlyByteBuffer(), proto.getTezUserPayload().getVersion()) : UserPayload.create(null);
        }
        return userPayload;
    }

    private static void setUserPayload(EntityDescriptor<?> entity, UserPayload payload) {
        if (payload != null) {
            entity.setUserPayload(payload);
        }
    }

    public static InputDescriptor convertInputDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        InputDescriptor id = InputDescriptor.create(className);
        DagTypeConverters.setUserPayload(id, payload);
        return id;
    }

    public static OutputDescriptor convertOutputDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        OutputDescriptor od = OutputDescriptor.create(className);
        DagTypeConverters.setUserPayload(od, payload);
        return od;
    }

    public static NamedEntityDescriptor convertNamedDescriptorFromProto(DAGProtos.TezNamedEntityDescriptorProto proto) {
        String name = proto.getName();
        String className = proto.getEntityDescriptor().getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto.getEntityDescriptor());
        NamedEntityDescriptor descriptor = new NamedEntityDescriptor(name, className);
        DagTypeConverters.setUserPayload(descriptor, payload);
        return descriptor;
    }

    public static InputInitializerDescriptor convertInputInitializerDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        InputInitializerDescriptor iid = InputInitializerDescriptor.create(className);
        DagTypeConverters.setUserPayload(iid, payload);
        return iid;
    }

    public static OutputCommitterDescriptor convertOutputCommitterDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        OutputCommitterDescriptor ocd = OutputCommitterDescriptor.create(className);
        DagTypeConverters.setUserPayload(ocd, payload);
        return ocd;
    }

    public static VertexManagerPluginDescriptor convertVertexManagerPluginDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        VertexManagerPluginDescriptor vmpd = VertexManagerPluginDescriptor.create(className);
        DagTypeConverters.setUserPayload(vmpd, payload);
        return vmpd;
    }

    public static EdgeManagerPluginDescriptor convertEdgeManagerPluginDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        EdgeManagerPluginDescriptor empd = EdgeManagerPluginDescriptor.create(className);
        DagTypeConverters.setUserPayload(empd, payload);
        return empd;
    }

    public static ProcessorDescriptor convertProcessorDescriptorFromDAGPlan(DAGProtos.TezEntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = DagTypeConverters.convertTezUserPayloadFromDAGPlan(proto);
        ProcessorDescriptor pd = ProcessorDescriptor.create(className);
        DagTypeConverters.setUserPayload(pd, payload);
        return pd;
    }

    public static TezAppMasterStatus convertTezAppMasterStatusFromProto(DAGClientAMProtocolRPC.TezAppMasterStatusProto proto) {
        switch (proto) {
            case INITIALIZING: {
                return TezAppMasterStatus.INITIALIZING;
            }
            case READY: {
                return TezAppMasterStatus.READY;
            }
            case RUNNING: {
                return TezAppMasterStatus.RUNNING;
            }
            case SHUTDOWN: {
                return TezAppMasterStatus.SHUTDOWN;
            }
        }
        throw new TezUncheckedException("Could not convert to TezSessionStatus from proto");
    }

    public static DAGClientAMProtocolRPC.TezAppMasterStatusProto convertTezAppMasterStatusToProto(TezAppMasterStatus status) {
        switch (status) {
            case INITIALIZING: {
                return DAGClientAMProtocolRPC.TezAppMasterStatusProto.INITIALIZING;
            }
            case READY: {
                return DAGClientAMProtocolRPC.TezAppMasterStatusProto.READY;
            }
            case RUNNING: {
                return DAGClientAMProtocolRPC.TezAppMasterStatusProto.RUNNING;
            }
            case SHUTDOWN: {
                return DAGClientAMProtocolRPC.TezAppMasterStatusProto.SHUTDOWN;
            }
        }
        throw new TezUncheckedException("Could not convert TezSessionStatus to proto");
    }

    public static DAGProtos.PlanLocalResourcesProto convertFromLocalResources(Map<String, LocalResource> localResources) {
        DAGProtos.PlanLocalResourcesProto.Builder builder = DAGProtos.PlanLocalResourcesProto.newBuilder();
        for (Map.Entry<String, LocalResource> entry : localResources.entrySet()) {
            DAGProtos.PlanLocalResource plr = DagTypeConverters.convertLocalResourceToPlanLocalResource(entry.getKey(), entry.getValue());
            builder.addLocalResources(plr);
        }
        return builder.build();
    }

    public static Map<String, LocalResource> convertFromPlanLocalResources(DAGProtos.PlanLocalResourcesProto proto) {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>(proto.getLocalResourcesCount());
        for (DAGProtos.PlanLocalResource plr : proto.getLocalResourcesList()) {
            String name = plr.getName();
            LocalResource lr = DagTypeConverters.convertPlanLocalResourceToLocalResource(plr);
            localResources.put(name, lr);
        }
        return localResources;
    }

    public static DAGProtos.PlanLocalResource convertLocalResourceToPlanLocalResource(String name, LocalResource lr) {
        DAGProtos.PlanLocalResource.Builder localResourcesBuilder = DAGProtos.PlanLocalResource.newBuilder();
        localResourcesBuilder.setName(name);
        localResourcesBuilder.setUri(DagTypeConverters.convertToDAGPlan(lr.getResource()));
        localResourcesBuilder.setSize(lr.getSize());
        localResourcesBuilder.setTimeStamp(lr.getTimestamp());
        localResourcesBuilder.setType(DagTypeConverters.convertToDAGPlan(lr.getType()));
        localResourcesBuilder.setVisibility(DagTypeConverters.convertToDAGPlan(lr.getVisibility()));
        if (lr.getType() == LocalResourceType.PATTERN) {
            if (lr.getPattern() == null || lr.getPattern().isEmpty()) {
                throw new TezUncheckedException("LocalResource type set to pattern but pattern is null or empty");
            }
            localResourcesBuilder.setPattern(lr.getPattern());
        }
        return localResourcesBuilder.build();
    }

    public static LocalResource convertPlanLocalResourceToLocalResource(DAGProtos.PlanLocalResource plr) {
        return LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)new Path(plr.getUri())), (LocalResourceType)DagTypeConverters.convertFromDAGPlan(plr.getType()), (LocalResourceVisibility)DagTypeConverters.convertFromDAGPlan(plr.getVisibility()), (long)plr.getSize(), (long)plr.getTimeStamp(), (String)(plr.hasPattern() ? plr.getPattern() : null));
    }

    public static TezCounters convertTezCountersFromProto(DAGProtos.TezCountersProto proto) {
        TezCounters counters = new TezCounters();
        for (DAGProtos.TezCounterGroupProto counterGroupProto : proto.getCounterGroupsList()) {
            CounterGroup group = (CounterGroup)counters.addGroup(counterGroupProto.getName(), counterGroupProto.getDisplayName());
            for (DAGProtos.TezCounterProto counterProto : counterGroupProto.getCountersList()) {
                Object counter = group.findCounter(counterProto.getName(), counterProto.getDisplayName());
                counter.setValue(counterProto.getValue());
            }
        }
        return counters;
    }

    public static DAGProtos.TezCountersProto convertTezCountersToProto(TezCounters counters) {
        DAGProtos.TezCountersProto.Builder builder = DAGProtos.TezCountersProto.newBuilder();
        Iterator groupIterator = counters.iterator();
        int groupIndex = 0;
        while (groupIterator.hasNext()) {
            CounterGroup counterGroup = (CounterGroup)groupIterator.next();
            DAGProtos.TezCounterGroupProto.Builder groupBuilder = DAGProtos.TezCounterGroupProto.newBuilder();
            groupBuilder.setName(counterGroup.getName());
            groupBuilder.setDisplayName(counterGroup.getDisplayName());
            Iterator counterIterator = counterGroup.iterator();
            int counterIndex = 0;
            while (counterIterator.hasNext()) {
                TezCounter counter = (TezCounter)counterIterator.next();
                DAGProtos.TezCounterProto tezCounterProto = DAGProtos.TezCounterProto.newBuilder().setName(counter.getName()).setDisplayName(counter.getDisplayName()).setValue(counter.getValue()).build();
                groupBuilder.addCounters(counterIndex, tezCounterProto);
                ++counterIndex;
            }
            builder.addCounterGroups(groupIndex, groupBuilder.build());
            ++groupIndex;
        }
        return builder.build();
    }

    public static DAGProtos.StatusGetOptsProto convertStatusGetOptsToProto(StatusGetOpts statusGetOpts) {
        switch (statusGetOpts) {
            case GET_COUNTERS: {
                return DAGProtos.StatusGetOptsProto.GET_COUNTERS;
            }
            case GET_MEMORY_USAGE: {
                return DAGProtos.StatusGetOptsProto.GET_MEMORY_USAGE;
            }
        }
        throw new TezUncheckedException("Could not convert StatusGetOpts to proto");
    }

    public static StatusGetOpts convertStatusGetOptsFromProto(DAGProtos.StatusGetOptsProto proto) {
        switch (proto) {
            case GET_COUNTERS: {
                return StatusGetOpts.GET_COUNTERS;
            }
            case GET_MEMORY_USAGE: {
                return StatusGetOpts.GET_MEMORY_USAGE;
            }
        }
        throw new TezUncheckedException("Could not convert to StatusGetOpts from proto");
    }

    public static List<DAGProtos.StatusGetOptsProto> convertStatusGetOptsToProto(Set<StatusGetOpts> statusGetOpts) {
        ArrayList<DAGProtos.StatusGetOptsProto> protos = new ArrayList<DAGProtos.StatusGetOptsProto>(statusGetOpts.size());
        for (StatusGetOpts opt : statusGetOpts) {
            protos.add(DagTypeConverters.convertStatusGetOptsToProto(opt));
        }
        return protos;
    }

    public static Set<StatusGetOpts> convertStatusGetOptsFromProto(List<DAGProtos.StatusGetOptsProto> protoList) {
        TreeSet<StatusGetOpts> opts = new TreeSet<StatusGetOpts>();
        for (DAGProtos.StatusGetOptsProto proto : protoList) {
            opts.add(DagTypeConverters.convertStatusGetOptsFromProto(proto));
        }
        return opts;
    }

    public static ByteString convertCredentialsToProto(Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        ByteString.Output output = ByteString.newOutput();
        DataOutputStream dos = new DataOutputStream((OutputStream)output);
        try {
            credentials.writeTokenStorageToStream(dos);
            return output.toByteString();
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to serialize Credentials", e);
        }
    }

    public static Credentials convertByteStringToCredentials(ByteString byteString) {
        if (byteString == null) {
            return null;
        }
        DataInputByteBuffer dib = new DataInputByteBuffer();
        dib.reset(new ByteBuffer[]{byteString.asReadOnlyByteBuffer()});
        Credentials credentials = new Credentials();
        try {
            credentials.readTokenStorageStream((DataInputStream)dib);
            return credentials;
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to deserialize Credentials", e);
        }
    }

    public static VertexLocationHint convertVertexLocationHintFromProto(DAGProtos.VertexLocationHintProto proto) {
        ArrayList<TaskLocationHint> outputList = new ArrayList<TaskLocationHint>(proto.getTaskLocationHintsCount());
        for (DAGProtos.PlanTaskLocationHint inputHint : proto.getTaskLocationHintsList()) {
            TaskLocationHint outputHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(inputHint.getHostList()), new HashSet<String>(inputHint.getRackList()));
            outputList.add(outputHint);
        }
        return VertexLocationHint.create(outputList);
    }

    public static DAGProtos.VertexLocationHintProto convertVertexLocationHintToProto(VertexLocationHint vertexLocationHint) {
        DAGProtos.VertexLocationHintProto.Builder builder = DAGProtos.VertexLocationHintProto.newBuilder();
        if (vertexLocationHint.getTaskLocationHints() != null) {
            for (TaskLocationHint taskLocationHint : vertexLocationHint.getTaskLocationHints()) {
                DAGProtos.PlanTaskLocationHint.Builder taskLHBuilder = DAGProtos.PlanTaskLocationHint.newBuilder();
                if (taskLocationHint.getHosts() != null) {
                    taskLHBuilder.addAllHost(taskLocationHint.getHosts());
                }
                if (taskLocationHint.getRacks() != null) {
                    taskLHBuilder.addAllRack(taskLocationHint.getRacks());
                }
                builder.addTaskLocationHints(taskLHBuilder.build());
            }
        }
        return builder.build();
    }

    public static UserPayload convertToTezUserPayload(@Nullable ByteBuffer payload, int version) {
        return UserPayload.create(payload, version);
    }

    @Nullable
    public static ByteBuffer convertFromTezUserPayload(@Nullable UserPayload payload) {
        if (payload == null) {
            return null;
        }
        return payload.getRawPayload();
    }

    public static DAGProtos.VertexExecutionContextProto convertToProto(Vertex.VertexExecutionContext context) {
        if (context == null) {
            return null;
        }
        DAGProtos.VertexExecutionContextProto.Builder builder = DAGProtos.VertexExecutionContextProto.newBuilder();
        builder.setExecuteInAm(context.shouldExecuteInAm());
        builder.setExecuteInContainers(context.shouldExecuteInContainers());
        if (context.getTaskSchedulerName() != null) {
            builder.setTaskSchedulerName(context.getTaskSchedulerName());
        }
        if (context.getContainerLauncherName() != null) {
            builder.setContainerLauncherName(context.getContainerLauncherName());
        }
        if (context.getTaskCommName() != null) {
            builder.setTaskCommName(context.getTaskCommName());
        }
        return builder.build();
    }

    public static Vertex.VertexExecutionContext convertFromProto(DAGProtos.VertexExecutionContextProto proto) {
        if (proto == null) {
            return null;
        }
        if (proto.getExecuteInAm()) {
            Vertex.VertexExecutionContext context = Vertex.VertexExecutionContext.createExecuteInAm(proto.getExecuteInAm());
            return context;
        }
        if (proto.getExecuteInContainers()) {
            Vertex.VertexExecutionContext context = Vertex.VertexExecutionContext.createExecuteInContainers(proto.getExecuteInContainers());
            return context;
        }
        String taskScheduler = proto.hasTaskSchedulerName() ? proto.getTaskSchedulerName() : null;
        String containerLauncher = proto.hasContainerLauncherName() ? proto.getContainerLauncherName() : null;
        String taskComm = proto.hasTaskCommName() ? proto.getTaskCommName() : null;
        Vertex.VertexExecutionContext context = Vertex.VertexExecutionContext.create(taskScheduler, containerLauncher, taskComm);
        return context;
    }

    public static List<DAGProtos.TezNamedEntityDescriptorProto> convertNamedEntityCollectionToProto(NamedEntityDescriptor[] namedEntityDescriptors) {
        ArrayList list = Lists.newArrayListWithCapacity((int)namedEntityDescriptors.length);
        for (NamedEntityDescriptor namedEntity : namedEntityDescriptors) {
            DAGProtos.TezNamedEntityDescriptorProto namedEntityProto = DagTypeConverters.convertNamedEntityToProto(namedEntity);
            list.add(namedEntityProto);
        }
        return list;
    }

    public static DAGProtos.TezNamedEntityDescriptorProto convertNamedEntityToProto(NamedEntityDescriptor namedEntityDescriptor) {
        DAGProtos.TezNamedEntityDescriptorProto.Builder builder = DAGProtos.TezNamedEntityDescriptorProto.newBuilder();
        builder.setName(namedEntityDescriptor.getEntityName());
        DAGProtos.TezEntityDescriptorProto entityProto = DagTypeConverters.convertToDAGPlan(namedEntityDescriptor);
        builder.setEntityDescriptor(entityProto);
        return builder.build();
    }

    public static DAGProtos.AMPluginDescriptorProto convertServicePluginDescriptorToProto(ServicePluginsDescriptor servicePluginsDescriptor) {
        DAGProtos.AMPluginDescriptorProto.Builder pluginDescriptorBuilder = DAGProtos.AMPluginDescriptorProto.newBuilder();
        if (servicePluginsDescriptor != null) {
            List<DAGProtos.TezNamedEntityDescriptorProto> namedEntityProtos;
            pluginDescriptorBuilder.setContainersEnabled(servicePluginsDescriptor.areContainersEnabled());
            pluginDescriptorBuilder.setUberEnabled(servicePluginsDescriptor.isUberEnabled());
            if (servicePluginsDescriptor.getTaskSchedulerDescriptors() != null && servicePluginsDescriptor.getTaskSchedulerDescriptors().length > 0) {
                namedEntityProtos = DagTypeConverters.convertNamedEntityCollectionToProto(servicePluginsDescriptor.getTaskSchedulerDescriptors());
                pluginDescriptorBuilder.addAllTaskSchedulers(namedEntityProtos);
            }
            if (servicePluginsDescriptor.getContainerLauncherDescriptors() != null && servicePluginsDescriptor.getContainerLauncherDescriptors().length > 0) {
                namedEntityProtos = DagTypeConverters.convertNamedEntityCollectionToProto(servicePluginsDescriptor.getContainerLauncherDescriptors());
                pluginDescriptorBuilder.addAllContainerLaunchers(namedEntityProtos);
            }
            if (servicePluginsDescriptor.getTaskCommunicatorDescriptors() != null && servicePluginsDescriptor.getTaskCommunicatorDescriptors().length > 0) {
                namedEntityProtos = DagTypeConverters.convertNamedEntityCollectionToProto(servicePluginsDescriptor.getTaskCommunicatorDescriptors());
                pluginDescriptorBuilder.addAllTaskCommunicators(namedEntityProtos);
            }
        } else {
            pluginDescriptorBuilder.setContainersEnabled(true).setUberEnabled(false);
        }
        return pluginDescriptorBuilder.build();
    }

    public static DAGProtos.CallerContextProto convertCallerContextToProto(CallerContext callerContext) {
        DAGProtos.CallerContextProto.Builder callerContextBuilder = DAGProtos.CallerContextProto.newBuilder();
        callerContextBuilder.setContext(callerContext.getContext());
        if (callerContext.getCallerId() != null) {
            callerContextBuilder.setCallerId(callerContext.getCallerId());
        }
        if (callerContext.getCallerType() != null) {
            callerContextBuilder.setCallerType(callerContext.getCallerType());
        }
        if (callerContext.getBlob() != null) {
            callerContextBuilder.setBlob(callerContext.getBlob());
        }
        return callerContextBuilder.build();
    }

    public static CallerContext convertCallerContextFromProto(DAGProtos.CallerContextProto proto) {
        CallerContext callerContext = CallerContext.create(proto.getContext(), proto.hasBlob() ? proto.getBlob() : null);
        if (proto.hasCallerType() && proto.hasCallerId()) {
            callerContext.setCallerIdAndType(proto.getCallerId(), proto.getCallerType());
        }
        return callerContext;
    }

    public static DAGProtos.ACLInfo convertDAGAccessControlsToProto(DAGAccessControls dagAccessControls) {
        if (dagAccessControls == null) {
            return null;
        }
        DAGProtos.ACLInfo.Builder builder = DAGProtos.ACLInfo.newBuilder();
        builder.addAllUsersWithViewAccess(dagAccessControls.getUsersWithViewACLs());
        builder.addAllUsersWithModifyAccess(dagAccessControls.getUsersWithModifyACLs());
        builder.addAllGroupsWithViewAccess(dagAccessControls.getGroupsWithViewACLs());
        builder.addAllGroupsWithModifyAccess(dagAccessControls.getGroupsWithModifyACLs());
        return builder.build();
    }

    public static DAGAccessControls convertDAGAccessControlsFromProto(DAGProtos.ACLInfo aclInfo) {
        if (aclInfo == null) {
            return null;
        }
        DAGAccessControls dagAccessControls = new DAGAccessControls();
        dagAccessControls.setUsersWithViewACLs(aclInfo.getUsersWithViewAccessList());
        dagAccessControls.setUsersWithModifyACLs(aclInfo.getUsersWithModifyAccessList());
        dagAccessControls.setGroupsWithViewACLs(aclInfo.getGroupsWithViewAccessList());
        dagAccessControls.setGroupsWithModifyACLs(aclInfo.getGroupsWithModifyAccessList());
        return dagAccessControls;
    }
}

