/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class DateValidator
extends BaseValidator {
    public static final String DEFAULT_DISPLAY_FORMAT = "MM/DD/YYYY";
    public static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private DateFormat _format;
    private String _displayFormat;
    private Date _minimum;
    private Date _maximum;
    private Calendar _calendar;
    private String _scriptPath = "/org/apache/tapestry/valid/DateValidator.script";
    private String _dateTooEarlyMessage;
    private String _dateTooLateMessage;
    private String _invalidDateFormatMessage;

    public DateValidator() {
    }

    public DateValidator(String initializer) {
        super(initializer);
    }

    public void setFormat(DateFormat value) {
        this._format = value;
    }

    public DateFormat getFormat() {
        return this._format;
    }

    public DateFormat getEffectiveFormat() {
        if (this._format == null) {
            return DEFAULT_DATE_FORMAT;
        }
        return this._format;
    }

    public String getDisplayFormat() {
        return this._displayFormat;
    }

    public void setDisplayFormat(String value) {
        this._displayFormat = value;
    }

    public String getEffectiveDisplayFormat() {
        if (this._displayFormat == null) {
            DateFormat format = this.getEffectiveFormat();
            if (format instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)format).toPattern();
            }
            return DEFAULT_DISPLAY_FORMAT;
        }
        return this._displayFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(IFormComponent file, Object value) {
        DateFormat format;
        if (value == null) {
            return null;
        }
        Date date = (Date)value;
        DateFormat dateFormat = format = this.getEffectiveFormat();
        synchronized (dateFormat) {
            return format.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toObject(IFormComponent field, String value) throws ValidatorException {
        Date result;
        if (this.checkRequired(field, value)) {
            return null;
        }
        DateFormat format = this.getEffectiveFormat();
        try {
            DateFormat dateFormat = format;
            synchronized (dateFormat) {
                result = format.parse(value);
            }
            if (this._calendar == null) {
                this._calendar = new GregorianCalendar();
            }
            this._calendar.setTime(result);
            if (this._calendar.get(1) < 1000) {
                result = null;
            }
        }
        catch (ParseException ex) {
            result = null;
        }
        if (result == null) {
            throw new ValidatorException(this.buildInvalidDateFormatMessage(field), ValidationConstraint.DATE_FORMAT);
        }
        if (this._minimum != null && this._minimum.compareTo(result) > 0) {
            throw new ValidatorException(this.buildDateTooEarlyMessage(field, format.format(this._minimum)), ValidationConstraint.TOO_SMALL);
        }
        if (this._maximum != null && this._maximum.compareTo(result) < 0) {
            throw new ValidatorException(this.buildDateTooLateMessage(field, format.format(this._maximum)), ValidationConstraint.TOO_LARGE);
        }
        return result;
    }

    public Date getMaximum() {
        return this._maximum;
    }

    public void setMaximum(Date maximum) {
        this._maximum = maximum;
    }

    public Date getMinimum() {
        return this._minimum;
    }

    public void setMinimum(Date minimum) {
        this._minimum = minimum;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled() || !this.isRequired()) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("requiredMessage", this.buildRequiredMessage(field));
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    public String getDateTooEarlyMessage() {
        return this._dateTooEarlyMessage;
    }

    public String getDateTooLateMessage() {
        return this._dateTooLateMessage;
    }

    public String getInvalidDateFormatMessage() {
        return this._invalidDateFormatMessage;
    }

    protected String buildInvalidDateFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this._invalidDateFormatMessage, "invalid-date-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), this.getEffectiveDisplayFormat());
    }

    protected String buildDateTooEarlyMessage(IFormComponent field, String earliestDate) {
        String pattern = this.getPattern(this._dateTooEarlyMessage, "date-too-early", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), earliestDate);
    }

    protected String buildDateTooLateMessage(IFormComponent field, String latestDate) {
        String pattern = this.getPattern(this._dateTooLateMessage, "date-too-late", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), latestDate);
    }

    public void setDateTooEarlyMessage(String string) {
        this._dateTooEarlyMessage = string;
    }

    public void setDateTooLateMessage(String string) {
        this._dateTooLateMessage = string;
    }

    public void setInvalidDateFormatMessage(String string) {
        this._invalidDateFormatMessage = string;
    }
}

