/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.BaseValidator;

public abstract class AbstractNumericValidator
extends BaseValidator {
    private boolean _zeroIsNull;
    private String _scriptPath = this.getDefaultScriptPath();
    private String _invalidNumericFormatMessage;
    private String _invalidIntegerFormatMessage;
    private String _numberTooSmallMessage;
    private String _numberTooLargeMessage;
    private String _numberRangeMessage;

    public AbstractNumericValidator() {
    }

    public AbstractNumericValidator(String initializer) {
        super(initializer);
    }

    public AbstractNumericValidator(boolean required) {
        super(required);
    }

    public boolean getZeroIsNull() {
        return this._zeroIsNull;
    }

    public void setZeroIsNull(boolean zeroIsNull) {
        this._zeroIsNull = zeroIsNull;
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    public String getInvalidNumericFormatMessage() {
        return this._invalidNumericFormatMessage;
    }

    public String getInvalidIntegerFormatMessage() {
        return this._invalidIntegerFormatMessage;
    }

    public String getNumberRangeMessage() {
        return this._numberRangeMessage;
    }

    public String getNumberTooLargeMessage() {
        return this._numberTooLargeMessage;
    }

    public String getNumberTooSmallMessage() {
        return this._numberTooSmallMessage;
    }

    public void setInvalidNumericFormatMessage(String string) {
        this._invalidNumericFormatMessage = string;
    }

    public void setInvalidIntegerFormatMessage(String string) {
        this._invalidIntegerFormatMessage = string;
    }

    public void setNumberRangeMessage(String string) {
        this._numberRangeMessage = string;
    }

    public void setNumberTooLargeMessage(String string) {
        this._numberTooLargeMessage = string;
    }

    public void setNumberTooSmallMessage(String string) {
        this._numberTooSmallMessage = string;
    }

    protected String buildInvalidNumericFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this.getInvalidNumericFormatMessage(), "invalid-numeric-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }

    protected String buildNumberTooSmallMessage(IFormComponent field, Number minimum) {
        String pattern = this.getPattern(this.getNumberTooSmallMessage(), "number-too-small", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), minimum);
    }

    protected String buildInvalidIntegerFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this.getInvalidIntegerFormatMessage(), "invalid-int-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }

    protected String buildNumberTooLargeMessage(IFormComponent field, Number maximum) {
        String pattern = this.getPattern(this.getNumberTooLargeMessage(), "number-too-large", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), maximum);
    }

    protected String buildNumberRangeMessage(IFormComponent field, Number mininum, Number maximum) {
        String pattern = this.getPattern(this.getNumberRangeMessage(), "number-range", field.getPage().getLocale());
        return this.formatString(pattern, new Object[]{field.getDisplayName(), mininum, maximum});
    }

    protected String buildRangeMessage(IFormComponent field, Number minimum, Number maximum) {
        if (minimum != null && maximum != null) {
            return this.buildNumberRangeMessage(field, minimum, maximum);
        }
        if (maximum != null) {
            return this.buildNumberTooLargeMessage(field, maximum);
        }
        return this.buildNumberTooSmallMessage(field, minimum);
    }

    protected abstract String getDefaultScriptPath();
}

