/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.exception;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.util.exception.ExceptionDescription;
import org.apache.tapestry.util.exception.ExceptionProperty;

public class ExceptionAnalyzer {
    private static final int SKIP_LEADING_WHITESPACE = 0;
    private static final int SKIP_T = 1;
    private static final int SKIP_OTHER_WHITESPACE = 2;
    private final List exceptionDescriptions = new ArrayList();
    private final List propertyDescriptions = new ArrayList();
    private final CharArrayWriter writer = new CharArrayWriter();
    private boolean exhaustive = false;

    public boolean isExhaustive() {
        return this.exhaustive;
    }

    public void setExhaustive(boolean value) {
        this.exhaustive = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionDescription[] analyze(Throwable exception) {
        Throwable thrown = exception;
        try {
            while (thrown != null) {
                thrown = this.buildDescription(thrown);
            }
            ExceptionDescription[] result = new ExceptionDescription[this.exceptionDescriptions.size()];
            ExceptionDescription[] exceptionDescriptionArray = this.exceptionDescriptions.toArray(result);
            return exceptionDescriptionArray;
        }
        finally {
            this.exceptionDescriptions.clear();
            this.propertyDescriptions.clear();
            this.writer.reset();
        }
    }

    protected Throwable buildDescription(Throwable exception) {
        BeanInfo info;
        Throwable next = null;
        String[] stackTrace = null;
        this.propertyDescriptions.clear();
        String message = exception.getMessage();
        Class<?> exceptionClass = exception.getClass();
        try {
            info = Introspector.getBeanInfo(exceptionClass, Throwable.class);
        }
        catch (IntrospectionException e) {
            return null;
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            Object value;
            PropertyDescriptor descriptor = descriptors[i];
            Method method = descriptor.getReadMethod();
            if (method == null) continue;
            try {
                value = method.invoke((Object)exception, null);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null || message != null && message.equals(value)) continue;
            if (value instanceof Throwable) {
                if (next != null) continue;
                next = (Throwable)value;
                continue;
            }
            String stringValue = value.toString().trim();
            if (stringValue.length() == 0) continue;
            ExceptionProperty property = new ExceptionProperty(descriptor.getDisplayName(), value);
            this.propertyDescriptions.add(property);
        }
        if (next == null || this.exhaustive) {
            stackTrace = this.getStackTrace(exception);
        }
        ExceptionProperty[] properties = new ExceptionProperty[this.propertyDescriptions.size()];
        ExceptionProperty[] propArray = this.propertyDescriptions.toArray(properties);
        ExceptionDescription description = new ExceptionDescription(exceptionClass.getName(), message, propArray, stackTrace);
        this.exceptionDescriptions.add(description);
        return next;
    }

    protected String[] getStackTrace(Throwable exception) {
        this.writer.reset();
        PrintWriter printWriter = new PrintWriter(this.writer);
        exception.printStackTrace(printWriter);
        printWriter.close();
        String fullTrace = this.writer.toString();
        this.writer.reset();
        StringReader stringReader = new StringReader(fullTrace);
        LineNumberReader lineReader = new LineNumberReader(stringReader);
        int lineNumber = 0;
        ArrayList<String> frames = new ArrayList<String>();
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (++lineNumber == 1) continue;
                frames.add(this.stripFrame(line));
            }
            lineReader.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        String[] result = new String[frames.size()];
        return frames.toArray(result);
    }

    private String stripFrame(String frame) {
        char[] array = frame.toCharArray();
        int i = 0;
        int state = 0;
        boolean more = true;
        while (more) {
            if (i == array.length) {
                return "";
            }
            char ch = array[i];
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        break;
                    }
                    if (ch == 'a') {
                        state = 1;
                        ++i;
                        break;
                    }
                    more = false;
                    break;
                }
                case 1: {
                    if (ch == 't') {
                        state = 2;
                        ++i;
                        break;
                    }
                    --i;
                    more = false;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        break;
                    }
                    more = false;
                }
            }
        }
        if (i == 0) {
            return frame;
        }
        return frame.substring(i);
    }

    public void reportException(Throwable exception, PrintStream stream) {
        ExceptionDescription[] descriptions = this.analyze(exception);
        for (int i = 0; i < descriptions.length; ++i) {
            int j;
            String message = descriptions[i].getMessage();
            if (message == null) {
                stream.println(descriptions[i].getExceptionClassName());
            } else {
                stream.println(descriptions[i].getExceptionClassName() + ": " + descriptions[i].getMessage());
            }
            ExceptionProperty[] properties = descriptions[i].getProperties();
            for (j = 0; j < properties.length; ++j) {
                stream.println("   " + properties[j].getName() + ": " + properties[j].getValue());
            }
            if (i + 1 == descriptions.length) {
                String[] stackTrace = descriptions[i].getStackTrace();
                for (j = 0; j < stackTrace.length; ++j) {
                    stream.println(stackTrace[j]);
                }
                continue;
            }
            stream.println();
        }
    }
}

