/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.Locatable;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.AssetFactory;
import org.apache.tapestry.services.ResponseBuilder;
import org.apache.tapestry.util.IdAllocator;

public class PageRenderSupportImpl
implements Locatable,
PageRenderSupport {
    private final AssetFactory _assetFactory;
    private final Location _location;
    private final ResponseBuilder _builder;
    private StringBuffer _initializationScript;
    private StringBuffer _bodyScript;
    private StringBuffer _imageInitializations;
    private Map _imageMap;
    private List _externalScripts;
    private final IdAllocator _idAllocator;
    private final String _preloadName;

    public PageRenderSupportImpl(AssetFactory assetFactory, String namespace, Location location, ResponseBuilder builder) {
        Defense.notNull((Object)assetFactory, (String)"assetService");
        this._assetFactory = assetFactory;
        this._location = location;
        this._idAllocator = new IdAllocator(namespace);
        this._builder = builder;
        this._preloadName = (namespace.equals("") ? "tapestry" : namespace) + "_preload";
    }

    public Location getLocation() {
        return this._location;
    }

    public String getPreloadedImageReference(String URL2) {
        String reference;
        if (this._imageMap == null) {
            this._imageMap = new HashMap();
        }
        if ((reference = (String)this._imageMap.get(URL2)) == null) {
            int count = this._imageMap.size();
            String varName = this._preloadName + "[" + count + "]";
            reference = varName + ".src";
            if (this._imageInitializations == null) {
                this._imageInitializations = new StringBuffer();
            }
            this._imageInitializations.append("  ");
            this._imageInitializations.append(varName);
            this._imageInitializations.append(" = new Image();\n");
            this._imageInitializations.append("  ");
            this._imageInitializations.append(reference);
            this._imageInitializations.append(" = \"");
            this._imageInitializations.append(URL2);
            this._imageInitializations.append("\";\n");
            this._imageMap.put(URL2, reference);
        }
        return reference;
    }

    public void addBodyScript(String script) {
        this.addBodyScript(null, script);
    }

    public void addBodyScript(IComponent target, String script) {
        if (!this._builder.isBodyScriptAllowed(target)) {
            return;
        }
        if (this._bodyScript == null) {
            this._bodyScript = new StringBuffer(script.length());
        }
        this._bodyScript.append(script);
    }

    public void addInitializationScript(String script) {
        this.addInitializationScript(null, script);
    }

    public void addInitializationScript(IComponent target, String script) {
        if (!this._builder.isInitializationScriptAllowed(target)) {
            return;
        }
        if (this._initializationScript == null) {
            this._initializationScript = new StringBuffer(script.length() + 1);
        }
        this._initializationScript.append(script);
        this._initializationScript.append('\n');
    }

    public void addExternalScript(Resource scriptLocation) {
        this.addExternalScript(null, scriptLocation);
    }

    public void addExternalScript(IComponent target, Resource scriptLocation) {
        if (!this._builder.isExternalScriptAllowed(target)) {
            return;
        }
        if (this._externalScripts == null) {
            this._externalScripts = new ArrayList();
        }
        if (this._externalScripts.contains(scriptLocation)) {
            return;
        }
        this._externalScripts.add(scriptLocation);
    }

    public String getUniqueString(String baseValue) {
        return this._idAllocator.allocateId(baseValue);
    }

    private void writeExternalScripts(IMarkupWriter writer, IRequestCycle cycle) {
        int count = Tapestry.size(this._externalScripts);
        for (int i = 0; i < count; ++i) {
            Resource scriptLocation = (Resource)this._externalScripts.get(i);
            IAsset asset = this._assetFactory.createAsset(scriptLocation, null);
            String url = asset.buildURL();
            this._builder.writeExternalScript(url, cycle);
        }
    }

    public void writeBodyScript(IMarkupWriter writer, IRequestCycle cycle) {
        if (!Tapestry.isEmpty(this._externalScripts)) {
            this.writeExternalScripts(writer, cycle);
        }
        if (!this.any(this._bodyScript) && !this.any(this._imageInitializations)) {
            return;
        }
        this._builder.beginBodyScript(cycle);
        if (this.any(this._imageInitializations)) {
            this._builder.writeImageInitializations(this._imageInitializations.toString(), this._preloadName, cycle);
        }
        if (this.any(this._bodyScript)) {
            this._builder.writeBodyScript(this._bodyScript.toString(), cycle);
        }
        this._builder.endBodyScript(cycle);
    }

    public void writeInitializationScript(IMarkupWriter writer) {
        if (!this.any(this._initializationScript)) {
            return;
        }
        this._builder.writeInitializationScript(this._initializationScript.toString());
    }

    private boolean any(StringBuffer buffer) {
        return buffer != null && buffer.length() > 0;
    }
}

