/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IJSONRender;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.json.IJSONWriter;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.services.RequestLocaleManager;
import org.apache.tapestry.services.ResponseBuilder;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebResponse;

public class JSONResponseBuilder
implements ResponseBuilder {
    protected IJSONWriter _writer;
    protected IMarkupWriter _nullWriter = NullWriter.getSharedInstance();
    protected List _parts = new ArrayList();
    protected RequestLocaleManager _localeManager;
    protected MarkupWriterSource _markupWriterSource;
    protected WebResponse _webResponse;

    public JSONResponseBuilder(RequestLocaleManager localeManager, MarkupWriterSource markupWriterSource, WebResponse webResponse) {
        this._localeManager = localeManager;
        this._markupWriterSource = markupWriterSource;
        this._webResponse = webResponse;
    }

    public boolean isDynamic() {
        return Boolean.TRUE;
    }

    public void renderResponse(IRequestCycle cycle) throws IOException {
        this._localeManager.persistLocale();
        IPage page = cycle.getPage();
        ContentType contentType = page.getResponseContentType();
        String encoding = contentType.getParameter("charset");
        if (encoding == null) {
            encoding = cycle.getEngine().getOutputEncoding();
            contentType.setParameter("charset", encoding);
        }
        PrintWriter printWriter = this._webResponse.getPrintWriter(contentType);
        this._writer = this._markupWriterSource.newJSONWriter(printWriter, contentType);
        this.parseParameters(cycle);
        cycle.renderPage(this);
        this._writer.close();
    }

    protected void parseParameters(IRequestCycle cycle) {
        String[] updateParts = cycle.getParameters("updateParts");
        for (int i = 0; i < updateParts.length; ++i) {
            this._parts.add(updateParts[i].toString());
        }
    }

    public void render(IMarkupWriter writer, IRender render, IRequestCycle cycle) {
        if (IJSONRender.class.isInstance(render) && IComponent.class.isInstance(render)) {
            IJSONRender json = (IJSONRender)((Object)render);
            IComponent component = (IComponent)render;
            if (!this._parts.contains(component.getId())) {
                render.render(this._nullWriter, cycle);
                return;
            }
            json.renderComponent(this._writer, cycle);
        }
        render.render(this._nullWriter, cycle);
    }

    public void updateComponent(String id) {
        if (!this._parts.contains(id)) {
            this._parts.add(id);
        }
    }

    public IMarkupWriter getWriter() {
        return this._nullWriter;
    }

    public IMarkupWriter getWriter(String id, String type) {
        return this._nullWriter;
    }

    public boolean isBodyScriptAllowed(IComponent target) {
        return false;
    }

    public boolean isExternalScriptAllowed(IComponent target) {
        return false;
    }

    public boolean isInitializationScriptAllowed(IComponent target) {
        return false;
    }

    public void beginBodyScript(IRequestCycle cycle) {
    }

    public void endBodyScript(IRequestCycle cycle) {
    }

    public void writeBodyScript(String script, IRequestCycle cycle) {
    }

    public void writeExternalScript(String url, IRequestCycle cycle) {
    }

    public void writeImageInitializations(String script, String preloadName, IRequestCycle cycle) {
    }

    public void writeInitializationScript(String script) {
    }
}

