/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Resource;
import org.apache.hivemind.service.ThreadLocale;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.asset.AssetFactory;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.describe.HTMLDescriber;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.engine.state.ApplicationStateManager;
import org.apache.tapestry.error.ExceptionPresenter;
import org.apache.tapestry.error.RequestExceptionReporter;
import org.apache.tapestry.error.StaleLinkExceptionPresenter;
import org.apache.tapestry.error.StaleSessionExceptionPresenter;
import org.apache.tapestry.listener.ListenerInvoker;
import org.apache.tapestry.listener.ListenerMapSource;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.services.ClassFinder;
import org.apache.tapestry.services.ComponentMessagesSource;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.services.CookieSource;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.LinkFactory;
import org.apache.tapestry.services.ObjectPool;
import org.apache.tapestry.services.RequestCycleFactory;
import org.apache.tapestry.services.ResetEventHub;
import org.apache.tapestry.services.ResponseRenderer;
import org.apache.tapestry.services.ServiceMap;
import org.apache.tapestry.services.TemplateSource;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.InfrastructureContribution;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.web.WebContext;
import org.apache.tapestry.web.WebContextResource;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebResponse;

public class InfrastructureImpl
implements Infrastructure {
    private List _normalContributions;
    private List _overrideContributions;
    private Map _properties = new HashMap();
    private boolean _initialized;
    private String _mode;
    private ErrorLog _errorLog;
    private ClassResolver _classResolver;
    private ThreadLocale _threadLocale;

    public void setLocale(Locale locale) {
        this._threadLocale.setLocale(locale);
    }

    public String getApplicationId() {
        return (String)this.getProperty("applicationId");
    }

    public IPropertySource getApplicationPropertySource() {
        return (IPropertySource)this.getProperty("applicationPropertySource");
    }

    public IApplicationSpecification getApplicationSpecification() {
        return (IApplicationSpecification)this.getProperty("applicationSpecification");
    }

    public ApplicationStateManager getApplicationStateManager() {
        return (ApplicationStateManager)this.getProperty("applicationStateManager");
    }

    public ClassResolver getClassResolver() {
        return this._classResolver;
    }

    public ComponentMessagesSource getComponentMessagesSource() {
        return (ComponentMessagesSource)this.getProperty("componentMessagesSource");
    }

    public ComponentPropertySource getComponentPropertySource() {
        return (ComponentPropertySource)this.getProperty("componentPropertySource");
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public Resource getContextRoot() {
        WebContext context = (WebContext)this.getProperty("context");
        return new WebContextResource(context, "/");
    }

    public DataSqueezer getDataSqueezer() {
        return (DataSqueezer)this.getProperty("dataSqueezer");
    }

    public IPropertySource getGlobalPropertySource() {
        return (IPropertySource)this.getProperty("globalPropertySource");
    }

    public LinkFactory getLinkFactory() {
        return (LinkFactory)this.getProperty("linkFactory");
    }

    public ObjectPool getObjectPool() {
        return (ObjectPool)this.getProperty("objectPool");
    }

    public IPageSource getPageSource() {
        return (IPageSource)this.getProperty("pageSource");
    }

    public WebRequest getRequest() {
        return (WebRequest)this.getProperty("request");
    }

    public RequestCycleFactory getRequestCycleFactory() {
        return (RequestCycleFactory)this.getProperty("requestCycleFactory");
    }

    public RequestExceptionReporter getRequestExceptionReporter() {
        return (RequestExceptionReporter)this.getProperty("requestExceptionReporter");
    }

    public ResetEventHub getResetEventHub() {
        return (ResetEventHub)this.getProperty("resetEventHub");
    }

    public WebResponse getResponse() {
        return (WebResponse)this.getProperty("response");
    }

    public ResponseRenderer getResponseRenderer() {
        return (ResponseRenderer)this.getProperty("responseRenderer");
    }

    public IScriptSource getScriptSource() {
        return (IScriptSource)this.getProperty("scriptSource");
    }

    public ServiceMap getServiceMap() {
        return (ServiceMap)this.getProperty("serviceMap");
    }

    public ISpecificationSource getSpecificationSource() {
        return (ISpecificationSource)this.getProperty("specificationSource");
    }

    public TemplateSource getTemplateSource() {
        return (TemplateSource)this.getProperty("templateSource");
    }

    public String getOutputEncoding() {
        return this.getApplicationPropertySource().getPropertyValue("org.apache.tapestry.output-encoding");
    }

    public MarkupWriterSource getMarkupWriterSource() {
        return (MarkupWriterSource)this.getProperty("markupWriterSource");
    }

    public HTMLDescriber getHTMLDescriber() {
        return (HTMLDescriber)this.getProperty("HTMLDescriber");
    }

    public ExceptionPresenter getExceptionPresenter() {
        return (ExceptionPresenter)this.getProperty("exceptionPresenter");
    }

    public ListenerMapSource getListenerMapSource() {
        return (ListenerMapSource)this.getProperty("listenerMapSource");
    }

    public StaleSessionExceptionPresenter getStaleSessionExceptionPresenter() {
        return (StaleSessionExceptionPresenter)this.getProperty("staleSessionExceptionPresenter");
    }

    public StaleLinkExceptionPresenter getStaleLinkExceptionPresenter() {
        return (StaleLinkExceptionPresenter)this.getProperty("staleLinkExceptionPresenter");
    }

    public ValueConverter getValueConverter() {
        return (ValueConverter)this.getProperty("valueConverter");
    }

    public ListenerInvoker getListenerInvoker() {
        return (ListenerInvoker)this.getProperty("listenerInvoker");
    }

    public AssetFactory getAssetFactory() {
        return (AssetFactory)this.getProperty("assetFactory");
    }

    public CookieSource getCookieSource() {
        return (CookieSource)this.getProperty("cookieSource");
    }

    public ClassFinder getClassFinder() {
        return (ClassFinder)this.getProperty("classFinder");
    }

    public IRequestCycle getRequestCycle() {
        return (IRequestCycle)this.getProperty("requestCycle");
    }

    public Object getProperty(String propertyName) {
        Defense.notNull((Object)propertyName, (String)"propertyName");
        if (!this._initialized) {
            throw new IllegalStateException(ImplMessages.infrastructureNotInitialized());
        }
        Object result = this._properties.get(propertyName);
        if (result == null) {
            throw new ApplicationRuntimeException(ImplMessages.missingInfrastructureProperty(propertyName));
        }
        return result;
    }

    public synchronized void initialize(String mode) {
        Defense.notNull((Object)mode, (String)"mode");
        if (this._initialized) {
            throw new IllegalStateException(ImplMessages.infrastructureAlreadyInitialized(mode, this._mode));
        }
        Map normalByMode = this.buildMapFromContributions(this._normalContributions, mode);
        Map normal = this.buildMapFromContributions(this._normalContributions, null);
        Map overrideByMode = this.buildMapFromContributions(this._overrideContributions, mode);
        Map override = this.buildMapFromContributions(this._overrideContributions, null);
        this.addToProperties(overrideByMode);
        this.addToProperties(override);
        this.addToProperties(normalByMode);
        this.addToProperties(normal);
        this._mode = mode;
        this._initialized = true;
    }

    private Map buildMapFromContributions(List contributions, String mode) {
        HashMap<String, InfrastructureContribution> result = new HashMap<String, InfrastructureContribution>();
        for (InfrastructureContribution ic : contributions) {
            if (!ic.matchesMode(mode)) continue;
            String propertyName = ic.getProperty();
            InfrastructureContribution existing = (InfrastructureContribution)((Object)result.get(propertyName));
            if (existing != null) {
                this._errorLog.error(ImplMessages.duplicateInfrastructureContribution(ic, existing.getLocation()), ic.getLocation(), null);
                continue;
            }
            result.put(propertyName, ic);
        }
        return result;
    }

    private void addToProperties(Map map) {
        for (InfrastructureContribution ic : map.values()) {
            String propertyName = ic.getProperty();
            if (this._properties.containsKey(propertyName)) continue;
            this._properties.put(propertyName, ic.getObject());
        }
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setThreadLocale(ThreadLocale threadLocale) {
        this._threadLocale = threadLocale;
    }

    public void setNormalContributions(List normalContributions) {
        this._normalContributions = normalContributions;
    }

    public void setOverrideContributions(List overrideContributions) {
        this._overrideContributions = overrideContributions;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

