/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resolver;

import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.MessageFormatter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.spec.IComponentSpecification;

final class ResolverMessages {
    private static final MessageFormatter _formatter = new MessageFormatter(ResolverMessages.class);

    private ResolverMessages() {
    }

    static String noSuchComponentType(String type, INamespace namespace) {
        return _formatter.format("no-such-component-type", (Object)type, (Object)namespace);
    }

    static String noSuchPage(String name, INamespace namespace) {
        return _formatter.format("no-such-page", (Object)name, (Object)namespace.getNamespaceId());
    }

    static String resolvingComponent(String type, INamespace namespace) {
        return _formatter.format("resolving-component", (Object)type, (Object)namespace);
    }

    static String checkingResource(Resource resource) {
        return _formatter.format("checking-resource", (Object)resource);
    }

    static String installingComponent(String type, INamespace namespace, IComponentSpecification specification) {
        return _formatter.format("installing-component", (Object)type, (Object)namespace, (Object)specification);
    }

    static String installingPage(String pageName, INamespace namespace, IComponentSpecification specification) {
        return _formatter.format("installing-page", (Object)pageName, (Object)namespace, (Object)specification);
    }

    static String resolvingPage(String pageName, INamespace namespace) {
        return _formatter.format("resolving-page", (Object)pageName, (Object)namespace);
    }

    static String foundFrameworkPage(String pageName) {
        return _formatter.format("found-framework-page", (Object)pageName);
    }

    static String foundHTMLTemplate(Resource resource) {
        return _formatter.format("found-html-template", (Object)resource);
    }

    public static String componentIsDeprecated(String componentType, Location location) {
        return _formatter.format("component-is-deprecated", (Object)componentType, (Object)HiveMind.getLocationString((Object)location));
    }

    static String webInfNotAllowed(String simpleName) {
        return _formatter.format("web-inf-not-allowed", (Object)simpleName);
    }
}

