/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.engine.ServiceEncoding;
import org.apache.tapestry.record.PropertyChange;
import org.apache.tapestry.record.PropertyPersistenceStrategy;
import org.apache.tapestry.record.RecordUtils;
import org.apache.tapestry.record.WebSessionAttributeCallback;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebSession;

public class SessionPropertyPersistenceStrategy
implements PropertyPersistenceStrategy {
    public static final String STRATEGY_ID = "session";
    private String _applicationId;
    private WebRequest _request;

    public void store(String pageName, String idPath, String propertyName, Object newValue) {
        Defense.notNull((Object)pageName, (String)"pageName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        WebSession session = this._request.getSession(true);
        String attributeName = RecordUtils.buildChangeKey(STRATEGY_ID, this._applicationId, pageName, idPath, propertyName);
        session.setAttribute(attributeName, newValue);
    }

    public Collection getStoredChanges(String pageName) {
        Defense.notNull((Object)pageName, (String)"pageName");
        WebSession session = this._request.getSession(false);
        if (session == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList result = new ArrayList();
        WebSessionAttributeCallback callback = new WebSessionAttributeCallback(){

            public void handleAttribute(WebSession sess, String name) {
                PropertyChange change = RecordUtils.buildChange(name, sess.getAttribute(name));
                result.add(change);
            }
        };
        RecordUtils.iterateOverMatchingAttributes(STRATEGY_ID, this._applicationId, pageName, session, callback);
        return result;
    }

    public void discardStoredChanges(String pageName) {
        WebSession session = this._request.getSession(false);
        if (session == null) {
            return;
        }
        WebSessionAttributeCallback callback = new WebSessionAttributeCallback(){

            public void handleAttribute(WebSession sess, String name) {
                sess.setAttribute(name, null);
            }
        };
        RecordUtils.iterateOverMatchingAttributes(STRATEGY_ID, this._applicationId, pageName, session, callback);
    }

    public void addParametersForPersistentProperties(ServiceEncoding encoding, boolean post) {
    }

    public void setApplicationId(String applicationName) {
        this._applicationId = applicationName;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }
}

