/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.multipart;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.multipart.MultipartMessages;
import org.apache.tapestry.multipart.UploadPart;
import org.apache.tapestry.multipart.ValuePart;
import org.apache.tapestry.request.IUploadFile;

public abstract class AbstractMultipartDecoder {
    protected int _maxSize = 10000000;
    protected int _thresholdSize = 1024;
    protected String _repositoryPath = System.getProperty("java.io.tmpdir");
    protected String _encoding;
    protected Map _uploadParts = new HashMap();
    private Map _valueParts = new HashMap();

    public IUploadFile getFileUpload(String parameterName) {
        return (IUploadFile)this._uploadParts.get(parameterName);
    }

    public void cleanup() {
        for (UploadPart part : this._uploadParts.values()) {
            part.cleanup();
        }
    }

    protected Map buildParameterMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry e : this._valueParts.entrySet()) {
            String name = (String)e.getKey();
            ValuePart part = (ValuePart)e.getValue();
            result.put(name, part.getValues());
        }
        return result;
    }

    protected void processFileItems(List parts) {
        if (parts == null) {
            return;
        }
        for (FileItem item : parts) {
            this.processFileItem(item);
        }
    }

    private void processFileItem(FileItem item) {
        if (item.isFormField()) {
            this.processFormFieldItem(item);
            return;
        }
        this.processUploadFileItem(item);
    }

    private void processUploadFileItem(FileItem item) {
        String name = item.getFieldName();
        UploadPart part = new UploadPart(item);
        this._uploadParts.put(name, part);
    }

    void processFormFieldItem(FileItem item) {
        String name = item.getFieldName();
        String value = this.extractFileItemValue(item);
        ValuePart part = (ValuePart)this._valueParts.get(name);
        if (part == null) {
            this._valueParts.put(name, new ValuePart(value));
        } else {
            part.add(value);
        }
    }

    private String extractFileItemValue(FileItem item) {
        try {
            return this._encoding == null ? item.getString() : item.getString(this._encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ApplicationRuntimeException(MultipartMessages.unsupportedEncoding(this._encoding, ex), (Throwable)ex);
        }
    }
}

