/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.listener;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.listener.ListenerMessages;
import org.apache.tapestry.listener.ListenerMethodInvoker;

public class ListenerMethodInvokerImpl
implements ListenerMethodInvoker {
    private final Method[] _methods;
    private final String _name;

    public ListenerMethodInvokerImpl(String name, Method[] methods) {
        Defense.notNull((Object)name, (String)"name");
        Defense.notNull((Object)methods, (String)"methods");
        this._name = name;
        this._methods = methods;
    }

    public void invokeListenerMethod(Object target, IRequestCycle cycle) {
        Object[] listenerParameters = cycle.getListenerParameters();
        if (this.searchAndInvoke(target, false, true, cycle, listenerParameters)) {
            return;
        }
        if (this.searchAndInvoke(target, true, true, cycle, listenerParameters)) {
            return;
        }
        if (this.searchAndInvoke(target, false, false, cycle, listenerParameters)) {
            return;
        }
        if (this.searchAndInvoke(target, true, false, cycle, listenerParameters)) {
            return;
        }
        throw new ApplicationRuntimeException(ListenerMessages.noListenerMethodFound(this._name, listenerParameters, target), target, null, null);
    }

    private boolean searchAndInvoke(Object target, boolean includeCycle, boolean includeParameters, IRequestCycle cycle, Object[] listenerParameters) {
        Method m;
        Class<?>[] parameterTypes;
        int methodParameterCount;
        int listenerParameterCount = Tapestry.size(listenerParameters);
        int n = methodParameterCount = includeParameters ? listenerParameterCount : 0;
        if (includeCycle) {
            ++methodParameterCount;
        }
        for (int i = 0; i < this._methods.length && (parameterTypes = (m = this._methods[i]).getParameterTypes()).length >= methodParameterCount; ++i) {
            boolean firstIsCycle;
            if (parameterTypes.length != methodParameterCount) continue;
            boolean bl = firstIsCycle = parameterTypes.length > 0 && parameterTypes[0] == IRequestCycle.class;
            if (includeCycle != firstIsCycle) continue;
            this.invokeListenerMethod(m, target, includeCycle, includeParameters, cycle, listenerParameters);
            return true;
        }
        return false;
    }

    private void invokeListenerMethod(Method listenerMethod, Object target, boolean includeCycle, boolean includeParameters, IRequestCycle cycle, Object[] listenerParameters) {
        Object[] parameters = new Object[listenerMethod.getParameterTypes().length];
        int cursor = 0;
        if (includeCycle) {
            parameters[cursor++] = cycle;
        }
        if (includeParameters) {
            for (int i = 0; i < Tapestry.size(listenerParameters); ++i) {
                parameters[cursor++] = listenerParameters[i];
            }
        }
        Object methodResult = null;
        try {
            methodResult = this.invokeTargetMethod(target, listenerMethod, parameters);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof ApplicationRuntimeException) {
                throw (ApplicationRuntimeException)targetException;
            }
            throw new ApplicationRuntimeException(ListenerMessages.listenerMethodFailure(listenerMethod, target, targetException), target, null, targetException);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ListenerMessages.listenerMethodFailure(listenerMethod, target, ex), target, null, (Throwable)ex);
        }
        if (methodResult == null) {
            return;
        }
        if (methodResult instanceof String) {
            cycle.activate((String)methodResult);
            return;
        }
        if (methodResult instanceof ILink) {
            ILink link = (ILink)methodResult;
            String url = link.getAbsoluteURL();
            cycle.sendRedirect(url);
            return;
        }
        cycle.activate((IPage)methodResult);
    }

    protected Object invokeTargetMethod(Object target, Method listenerMethod, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        return listenerMethod.invoke(target, parameters);
    }
}

