/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.link;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.ILinkRenderer;
import org.apache.tapestry.link.LinkMessages;

public class DefaultLinkRenderer
implements ILinkRenderer {
    public static final ILinkRenderer SHARED_INSTANCE = new DefaultLinkRenderer();

    public void renderLink(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent linkComponent) {
        boolean disabled;
        IMarkupWriter wrappedWriter = null;
        if (cycle.getAttribute("org.apache.tapestry.active-link-component") != null) {
            throw new ApplicationRuntimeException(LinkMessages.noNesting(), (Object)linkComponent, null, null);
        }
        cycle.setAttribute("org.apache.tapestry.active-link-component", linkComponent);
        boolean hasBody = this.getHasBody();
        boolean bl = disabled = linkComponent.isDisabled() || cycle.isRewinding();
        if (!disabled) {
            if (hasBody) {
                writer.begin(this.getElement());
            } else {
                writer.beginEmpty(this.getElement());
            }
            writer.attribute(this.getUrlAttribute(), this.constructURL(linkComponent, cycle));
            String target = linkComponent.getTarget();
            if (HiveMind.isNonBlank((String)target)) {
                writer.attribute(this.getTargetAttribute(), target);
            }
            this.beforeBodyRender(writer, cycle, linkComponent);
            wrappedWriter = writer.getNestedWriter();
        } else {
            wrappedWriter = writer;
        }
        if (hasBody) {
            linkComponent.renderBody(wrappedWriter, cycle);
        }
        if (!disabled) {
            this.afterBodyRender(writer, cycle, linkComponent);
            linkComponent.renderAdditionalAttributes(writer, cycle);
            if (hasBody) {
                wrappedWriter.close();
                writer.end();
            } else {
                writer.closeTag();
            }
        }
        cycle.removeAttribute("org.apache.tapestry.active-link-component");
    }

    protected String constructURL(ILinkComponent component, IRequestCycle cycle) {
        ILink link = component.getLink(cycle);
        String scheme = component.getScheme();
        Integer port = component.getPort();
        int portI = port == null ? 0 : port;
        String anchor = component.getAnchor();
        return link.getURL(scheme, null, portI, anchor, true);
    }

    protected void beforeBodyRender(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent link) {
    }

    protected void afterBodyRender(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent link) {
    }

    protected String getElement() {
        return "a";
    }

    protected String getUrlAttribute() {
        return "href";
    }

    protected String getTargetAttribute() {
        return "target";
    }

    protected boolean getHasBody() {
        return true;
    }
}

