/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.json;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.tapestry.json.JSONArray;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONTokener;

public class JSONObject {
    public static final Object NULL = new Null();
    private HashMap myHashMap;

    public JSONObject() {
        this.myHashMap = new HashMap();
    }

    public JSONObject(JSONObject jo, String[] sa) {
        this();
        for (int i = 0; i < sa.length; ++i) {
            this.putOpt(sa[i], jo.opt(sa[i]));
        }
    }

    public JSONObject(JSONTokener x) throws ParseException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.myHashMap.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        this.myHashMap = new HashMap(map);
    }

    public JSONObject(String string) throws ParseException {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String key, Object value) {
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            a.put(value);
        } else {
            JSONArray a = new JSONArray();
            a.put(o);
            a.put(value);
            this.put(key, a);
        }
        return this;
    }

    public Object get(String key) {
        Object o = this.opt(key);
        if (o == null) {
            throw new NoSuchElementException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new ClassCastException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return new Double((String)o);
        }
        throw new NumberFormatException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
    }

    HashMap getHashMap() {
        return this.myHashMap;
    }

    public int getInt(String key) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new NoSuchElementException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new NoSuchElementException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public String getString(String key) {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) {
        if (n instanceof Float && (((Float)n).isInfinite() || ((Float)n).isNaN()) || n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN())) {
            throw new ArithmeticException("JSON can only serialize finite numbers.");
        }
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        return this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        return defaultValue;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            try {
                return new Double((String)o);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, double value) {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(char value) {
        return JSONObject.quote(new String(new char[]{value}));
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    public JSONArray toJSONArray(JSONArray names) {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        while (keys.hasNext()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            Object o = keys.next();
            sb.append(JSONObject.quote(o.toString()));
            sb.append(':');
            sb.append(JSONObject.valueToString(this.myHashMap.get(o)));
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JSONObject.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.myHashMap.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONObject.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.myHashMap.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray || value instanceof JSONLiteral) {
            return value.toString();
        }
        return JSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (JSONLiteral.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        return JSONObject.quote(value.toString());
    }

    private static final class Null {
        private Null() {
        }

        protected Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

