/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.json;

import java.text.ParseException;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.json.JSONTokener;

public final class Cookie {
    private Cookie() {
    }

    public static String escape(String string) {
        String s = string.trim();
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c == '+' || c == '%' || c == '=' || c == ';') {
                sb.append('%');
                sb.append(Character.forDigit((char)(c >>> 4 & 0xF), 16));
                sb.append(Character.forDigit((char)(c & 0xF), 16));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject toJSONObject(String string) throws ParseException {
        JSONObject o = new JSONObject();
        JSONTokener x = new JSONTokener(string);
        o.put("name", x.nextTo('='));
        x.next('=');
        o.put("value", x.nextTo(';'));
        x.next();
        while (x.more()) {
            Object v;
            String n = JSONTokener.unescape(x.nextTo("=;"));
            if (x.next() != '=') {
                if (!n.equals("secure")) throw x.syntaxError("Missing '=' in cookie parameter.");
                v = Boolean.TRUE;
            } else {
                v = JSONTokener.unescape(x.nextTo(';'));
                x.next();
            }
            o.put(n, v);
        }
        return o;
    }

    public static String toString(JSONObject o) {
        StringBuffer sb = new StringBuffer();
        sb.append(Cookie.escape(o.getString("name")));
        sb.append("=");
        sb.append(Cookie.escape(o.getString("value")));
        if (o.has("expires")) {
            sb.append(";expires=");
            sb.append(o.getString("expires"));
        }
        if (o.has("domain")) {
            sb.append(";domain=");
            sb.append(Cookie.escape(o.getString("domain")));
        }
        if (o.has("path")) {
            sb.append(";path=");
            sb.append(Cookie.escape(o.getString("path")));
        }
        if (o.optBoolean("secure")) {
            sb.append(";secure");
        }
        return sb.toString();
    }
}

