/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import java.text.DecimalFormatSymbols;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class Max
extends BaseValidator {
    private double _max;

    public Max() {
    }

    public Max(String initializer) {
        super(initializer);
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        Number value = (Number)object;
        if (value.doubleValue() > this._max) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.TOO_LARGE);
        }
    }

    private String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "number-too-large", new Object[]{field.getDisplayName(), new Double(this._max)});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        JSONObject profile = context.getProfile();
        if (!profile.has("constraints")) {
            profile.put("constraints", new JSONObject());
        }
        JSONObject cons = profile.getJSONObject("constraints");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(context.getLocale());
        this.accumulateProperty(cons, field.getClientId(), new JSONLiteral("[dojo.validate.isInRange,{max:" + this._max + "," + "decimal:" + JSONObject.quote(symbols.getDecimalSeparator()) + "}]"));
        this.accumulateProfileProperty(field, profile, "constraints", this.buildMessage(context, field));
    }

    public void setMax(double max) {
        this._max = max;
    }
}

