/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.util.RegexpMatcher;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class Email
extends BaseValidator {
    static final String PATTERN = "^\\w[-._\\w]*\\w@\\w[-._\\w]*\\w\\.\\w{2,6}$";
    private RegexpMatcher _matcher = new RegexpMatcher();

    public Email() {
    }

    public Email(String initializer) {
        super(initializer);
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        String input = (String)object;
        if (!this._matcher.matches(PATTERN, input)) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.EMAIL_FORMAT);
        }
    }

    private String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "invalid-email-format", new Object[]{field.getDisplayName()});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        context.addInitializationScript(field, "dojo.require(\"dojo.validate.web\");");
        JSONObject profile = context.getProfile();
        if (!profile.has("constraints")) {
            profile.put("constraints", new JSONObject());
        }
        JSONObject cons = profile.getJSONObject("constraints");
        this.accumulateProperty(cons, field.getClientId(), new JSONLiteral("[dojo.validate.isEmailAddress,false,true]"));
        this.accumulateProfileProperty(field, profile, "constraints", this.buildMessage(context, field));
    }
}

