/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.Iterator;
import org.apache.hivemind.service.ThreadLocale;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.form.FormComponentContributorContextImpl;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.form.ValidationMessagesImpl;
import org.apache.tapestry.form.validator.Validator;
import org.apache.tapestry.valid.ValidatorException;

public class ValidatableFieldSupportImpl
implements ValidatableFieldSupport {
    private ValueConverter _converter;
    private ThreadLocale _threadLocale;

    public void setValueConverter(ValueConverter converter) {
        this._converter = converter;
    }

    public void setThreadLocale(ThreadLocale threadLocale) {
        this._threadLocale = threadLocale;
    }

    protected Iterator getValidatorsIterator(ValidatableField component) {
        return (Iterator)this._converter.coerceValue(component.getValidators(), Iterator.class);
    }

    public void renderContributions(ValidatableField component, IMarkupWriter writer, IRequestCycle cycle) {
        if (component.getForm().isClientValidationEnabled()) {
            FormComponentContributorContextImpl context = new FormComponentContributorContextImpl(this._threadLocale.getLocale(), cycle, component);
            Iterator validators = this.getValidatorsIterator(component);
            while (validators.hasNext()) {
                Validator validator = (Validator)validators.next();
                validator.renderContribution(writer, cycle, context, component);
            }
        }
    }

    public void validate(ValidatableField component, IMarkupWriter writer, IRequestCycle cycle, Object object) throws ValidatorException {
        boolean isNonNull = object != null;
        Iterator validators = this.getValidatorsIterator(component);
        ValidationMessagesImpl messages = new ValidationMessagesImpl(component, this._threadLocale.getLocale());
        while (validators.hasNext()) {
            Validator validator = (Validator)validators.next();
            if (!isNonNull && !validator.getAcceptsNull()) continue;
            validator.validate(component, messages, object);
        }
    }

    public boolean isRequired(ValidatableField field) {
        Iterator i = this.getValidatorsIterator(field);
        while (i.hasNext()) {
            Validator validator = (Validator)i.next();
            if (!validator.isRequired()) continue;
            return true;
        }
        return false;
    }
}

