/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.event;

import java.util.HashMap;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.EventTarget;

public class BrowserEvent {
    public static final String NAME = "beventname";
    public static final String TYPE = "beventtype";
    public static final String KEYS = "beventkeys";
    public static final String CHAR_CODE = "beventcharCode";
    public static final String PAGE_X = "beventpageX";
    public static final String PAGE_Y = "beventpageY";
    public static final String LAYER_X = "beventlayerX";
    public static final String LAYER_Y = "beventlayerY";
    public static final String TARGET = "beventtarget";
    public static final String TARGET_ATTR_ID = "id";
    private String _name;
    private String _type;
    private String[] _keys;
    private String _charCode;
    private String _pageX;
    private String _pageY;
    private String _layerX;
    private String _layerY;
    private EventTarget _target;

    public BrowserEvent(IRequestCycle cycle) {
        Defense.notNull((Object)cycle, (String)"cycle");
        this._name = cycle.getParameter(NAME);
        this._type = cycle.getParameter(TYPE);
        this._keys = cycle.getParameters(KEYS);
        this._charCode = cycle.getParameter(CHAR_CODE);
        this._pageX = cycle.getParameter(PAGE_X);
        this._pageY = cycle.getParameter(PAGE_Y);
        this._layerX = cycle.getParameter(LAYER_X);
        this._layerY = cycle.getParameter(LAYER_Y);
        HashMap<String, String> props = new HashMap<String, String>();
        this._target = new EventTarget(props);
        String targetId = cycle.getParameter("beventtarget.id");
        if (targetId != null) {
            props.put(TARGET_ATTR_ID, targetId);
        }
    }

    public BrowserEvent(String name, EventTarget target) {
        this._name = name;
        this._target = target;
    }

    public String getName() {
        return this._name;
    }

    public EventTarget getTarget() {
        return this._target;
    }

    public String getCharCode() {
        return this._charCode;
    }

    public String[] getKeys() {
        return this._keys;
    }

    public String getLayerX() {
        return this._layerX;
    }

    public String getLayerY() {
        return this._layerY;
    }

    public String getPageX() {
        return this._pageX;
    }

    public String getPageY() {
        return this._pageY;
    }

    public String getType() {
        return this._type;
    }

    public static boolean hasBrowserEvent(IRequestCycle cycle) {
        Defense.notNull((Object)cycle, (String)"cycle");
        return cycle.getParameter(NAME) != null;
    }
}

