/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectSpecificationWorker
implements EnhancementWorker {
    public static final String SPECIFICATION_PROPERTY_NAME = "specification";
    private ErrorLog _errorLog;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        try {
            this.injectSpecification(op, spec);
        }
        catch (Exception ex) {
            this._errorLog.error(EnhanceMessages.errorAddingProperty(SPECIFICATION_PROPERTY_NAME, op.getBaseClass(), ex), spec.getLocation(), (Throwable)ex);
        }
    }

    public void injectSpecification(EnhancementOperation op, IComponentSpecification spec) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)spec, (String)"spec");
        op.claimReadonlyProperty(SPECIFICATION_PROPERTY_NAME);
        String fieldName = op.addInjectedField("_$specification", IComponentSpecification.class, spec);
        EnhanceUtils.createSimpleAccessor(op, fieldName, SPECIFICATION_PROPERTY_NAME, IComponentSpecification.class, spec.getLocation());
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

