/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.spec.IComponentSpecification;

public final class EnhanceUtils {
    public static final MethodSignature FINISH_LOAD_SIGNATURE = new MethodSignature(Void.TYPE, "finishLoad", new Class[]{IRequestCycle.class, IPageLoader.class, IComponentSpecification.class}, null);
    public static final MethodSignature PAGE_DETACHED_SIGNATURE = new MethodSignature(Void.TYPE, "pageDetached", new Class[]{PageEvent.class}, null);
    public static final MethodSignature CLEANUP_AFTER_RENDER_SIGNATURE = new MethodSignature(Void.TYPE, "cleanupAfterRender", new Class[]{IRequestCycle.class}, null);
    private static Map _unwrappers = new HashMap();

    private EnhanceUtils() {
    }

    public static String createMutatorMethodName(String propertyName) {
        return "set" + EnhanceUtils.upcase(propertyName);
    }

    public static String createAccessorMethodName(String propertyName) {
        return "get" + EnhanceUtils.upcase(propertyName);
    }

    private static String upcase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static void createSimpleAccessor(EnhancementOperation op, String fieldName, String propertyName, Class propertyType, Location location) {
        String methodName = op.getAccessorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(propertyType, methodName, null, null), "return " + fieldName + ";", location);
    }

    public static void createSimpleMutator(EnhancementOperation op, String fieldName, String propertyName, Class propertyType, Location location) {
        String methodName = EnhanceUtils.createMutatorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(Void.TYPE, methodName, new Class[]{propertyType}, null), fieldName + " = $1;", location);
    }

    public static Class extractPropertyType(EnhancementOperation op, String propertyName, String definedTypeName) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        if (definedTypeName != null) {
            Class propertyType = op.convertTypeName(definedTypeName);
            op.validateProperty(propertyName, propertyType);
            return propertyType;
        }
        Class propertyType = op.getPropertyType(propertyName);
        return propertyType == null ? Object.class : propertyType;
    }

    public static boolean toBoolean(IBinding binding) {
        Boolean wrapped = (Boolean)binding.getObject(Boolean.class);
        return wrapped == null ? false : wrapped;
    }

    public static byte toByte(IBinding binding) {
        Byte wrapped = (Byte)binding.getObject(Byte.class);
        return wrapped == null ? (byte)0 : wrapped;
    }

    public static char toChar(IBinding binding) {
        Character wrapped = (Character)binding.getObject(Character.class);
        return wrapped == null ? (char)'\u0000' : wrapped.charValue();
    }

    public static short toShort(IBinding binding) {
        Short wrapped = (Short)binding.getObject(Short.class);
        return wrapped == null ? (short)0 : wrapped;
    }

    public static int toInt(IBinding binding) {
        Integer wrapped = (Integer)binding.getObject(Integer.class);
        return wrapped == null ? 0 : wrapped;
    }

    public static long toLong(IBinding binding) {
        Long wrapped = (Long)binding.getObject(Long.class);
        return wrapped == null ? 0L : wrapped;
    }

    public static float toFloat(IBinding binding) {
        Float wrapped = (Float)binding.getObject(Float.class);
        return wrapped == null ? 0.0f : wrapped.floatValue();
    }

    public static double toDouble(IBinding binding) {
        Double wrapped = (Double)binding.getObject(Double.class);
        return wrapped == null ? 0.0 : wrapped;
    }

    public static String getUnwrapperMethodName(Class type) {
        Defense.notNull((Object)type, (String)"type");
        return (String)_unwrappers.get(type);
    }

    public static String createUnwrapExpression(EnhancementOperation op, String bindingName, Class valueType) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)bindingName, (String)"bindingName");
        Defense.notNull((Object)valueType, (String)"valueType");
        StringBuffer buffer = new StringBuffer();
        String unwrapper = EnhanceUtils.getUnwrapperMethodName(valueType);
        if (unwrapper == null) {
            String propertyTypeRef = op.getClassReference(valueType);
            buffer.append("(");
            buffer.append(ClassFabUtils.getJavaClassName((Class)valueType));
            buffer.append(") ");
            buffer.append(bindingName);
            buffer.append(".getObject(");
            buffer.append(propertyTypeRef);
            buffer.append(")");
        } else {
            buffer.append(EnhanceUtils.class.getName());
            buffer.append(".");
            buffer.append(unwrapper);
            buffer.append("(");
            buffer.append(bindingName);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static Class verifyPropertyType(EnhancementOperation op, String propertyName, Class requiredType) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Defense.notNull((Object)requiredType, (String)"requiredType");
        Class propertyType = op.getPropertyType(propertyName);
        if (propertyType == null) {
            return Object.class;
        }
        if (!propertyType.isAssignableFrom(requiredType)) {
            throw new ApplicationRuntimeException(EnhanceMessages.wrongTypeForProperty(propertyName, propertyType, requiredType));
        }
        return propertyType;
    }

    static {
        _unwrappers.put(Boolean.TYPE, "toBoolean");
        _unwrappers.put(Byte.TYPE, "toByte");
        _unwrappers.put(Character.TYPE, "toChar");
        _unwrappers.put(Short.TYPE, "toShort");
        _unwrappers.put(Integer.TYPE, "toInt");
        _unwrappers.put(Long.TYPE, "toLong");
        _unwrappers.put(Float.TYPE, "toFloat");
        _unwrappers.put(Double.TYPE, "toDouble");
    }
}

