/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.spec.IComponentSpecification;

public class AbstractPropertyWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Location location = spec.getLocation();
        for (String name : op.findUnclaimedAbstractProperties()) {
            try {
                this.createProperty(op, name, location);
            }
            catch (Exception ex) {
                this._errorLog.error(EnhanceMessages.errorAddingProperty(name, op.getBaseClass(), ex), location, (Throwable)ex);
            }
        }
    }

    private void createProperty(EnhancementOperation op, String name, Location location) {
        Class propertyType = op.getPropertyType(name);
        String fieldName = "_$" + name;
        String defaultFieldName = fieldName + "$defaultValue";
        op.addField(fieldName, propertyType);
        op.addField(defaultFieldName, propertyType);
        EnhanceUtils.createSimpleAccessor(op, fieldName, name, propertyType, location);
        EnhanceUtils.createSimpleMutator(op, fieldName, name, propertyType, location);
        op.extendMethodImplementation(IComponent.class, EnhanceUtils.FINISH_LOAD_SIGNATURE, defaultFieldName + " = " + fieldName + ";");
        op.extendMethodImplementation(PageDetachListener.class, EnhanceUtils.PAGE_DETACHED_SIGNATURE, fieldName + " = " + defaultFieldName + ";");
        op.claimProperty(name);
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

