/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine.state;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.tapestry.engine.state.StateMessages;
import org.apache.tapestry.engine.state.StateObjectContribution;
import org.apache.tapestry.engine.state.StateObjectManager;
import org.apache.tapestry.engine.state.StateObjectManagerImpl;
import org.apache.tapestry.engine.state.StateObjectManagerRegistry;
import org.apache.tapestry.engine.state.StateObjectPersistenceManager;

public class SOMRegistryImpl
implements StateObjectManagerRegistry {
    private ErrorLog _errorLog;
    private Map _factoryContributions;
    private Map _applicationContributions;
    private Map _persistenceManagers;
    private Map _objectManagers = new HashMap();

    public void initializeService() {
        HashMap contributions = new HashMap();
        contributions.putAll(this._factoryContributions);
        contributions.putAll(this._applicationContributions);
        for (StateObjectContribution c : contributions.values()) {
            String objectName = c.getName();
            String scope = c.getScope();
            StateObjectPersistenceManager pm = (StateObjectPersistenceManager)this._persistenceManagers.get(scope);
            if (pm == null) {
                this._errorLog.error(StateMessages.unknownScope(objectName, scope), c.getLocation(), null);
                continue;
            }
            StateObjectManagerImpl manager = new StateObjectManagerImpl(objectName, c.getFactory(), pm);
            this._objectManagers.put(objectName, manager);
        }
    }

    public StateObjectManager get(String objectName) {
        StateObjectManager manager = (StateObjectManager)this._objectManagers.get(objectName);
        if (manager == null) {
            throw new ApplicationRuntimeException(StateMessages.unknownStateObjectName(objectName));
        }
        return manager;
    }

    public void setApplicationContributions(Map applicationContributions) {
        this._applicationContributions = applicationContributions;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setFactoryContributions(Map factoryContributions) {
        this._factoryContributions = factoryContributions;
    }

    public void setPersistenceManagers(Map persistenceManagers) {
        this._persistenceManagers = persistenceManagers;
    }
}

