/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.net.URLCodec;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.EngineUtils;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.util.QueryParameterMap;
import org.apache.tapestry.web.WebRequest;

public class EngineServiceLink
implements ILink {
    private static final int DEFAULT_HTTP_PORT = 80;
    private final String _servletPath;
    private final URLCodec _codec;
    private IRequestCycle _cycle;
    private String _encoding;
    private final QueryParameterMap _parameters;
    private final WebRequest _request;

    public EngineServiceLink(String servletPath, String encoding, URLCodec codec, WebRequest request, Map parameters, boolean stateful) {
        Defense.notNull((Object)servletPath, (String)"servletPath");
        Defense.notNull((Object)encoding, (String)"encoding");
        Defense.notNull((Object)codec, (String)"codec");
        Defense.notNull((Object)request, (String)"request");
        Defense.notNull((Object)parameters, (String)"parameters");
        this._servletPath = servletPath;
        this._encoding = encoding;
        this._codec = codec;
        this._request = request;
        this._parameters = new QueryParameterMap(parameters);
    }

    public EngineServiceLink(IRequestCycle cycle, String servletPath, String encoding, URLCodec codec, WebRequest request, Map parameters, boolean stateful) {
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)servletPath, (String)"servletPath");
        Defense.notNull((Object)encoding, (String)"encoding");
        Defense.notNull((Object)codec, (String)"codec");
        Defense.notNull((Object)request, (String)"request");
        Defense.notNull((Object)parameters, (String)"parameters");
        this._cycle = cycle;
        this._servletPath = servletPath;
        this._encoding = encoding;
        this._codec = codec;
        this._request = request;
        this._parameters = new QueryParameterMap(parameters);
    }

    public String getURL() {
        return this.getURL(null, true);
    }

    public String getURL(String anchor, boolean includeParameters) {
        return this.constructURL(new StringBuffer(), anchor, includeParameters);
    }

    public String getAbsoluteURL() {
        return this.getAbsoluteURL(null, null, 0, null, true);
    }

    public String getURL(String scheme, String server, int port, String anchor, boolean includeParameters) {
        boolean useAbsolute = EngineUtils.needAbsoluteURL(scheme, server, port, this._request);
        return useAbsolute ? this.getAbsoluteURL(scheme, server, port, anchor, includeParameters) : this.getURL(anchor, includeParameters);
    }

    public String getAbsoluteURL(String scheme, String server, int port, String anchor, boolean includeParameters) {
        StringBuffer buffer = new StringBuffer();
        int nport = port == 0 ? this._request.getServerPort() : port;
        String nscheme = scheme == null ? this._request.getScheme() : scheme;
        buffer.append(nscheme);
        buffer.append("://");
        buffer.append(server == null ? this._request.getServerName() : server);
        if (!nscheme.equals("http") || nport != 80) {
            buffer.append(':');
            buffer.append(nport);
        }
        return this.constructURL(buffer, anchor, includeParameters);
    }

    private String constructURL(StringBuffer buffer, String anchor, boolean includeParameters) {
        buffer.append(this._servletPath);
        if (includeParameters) {
            this.addParameters(buffer);
        }
        if (anchor != null) {
            buffer.append('#');
            buffer.append(anchor);
        }
        String result = buffer.toString();
        if (this._cycle != null) {
            result = this._cycle.encodeURL(result);
        }
        return result;
    }

    private void addParameters(StringBuffer buffer) {
        String[] names = this.getParameterNames();
        String sep = "?";
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String[] values = this.getParameterValues(name);
            if (values == null) continue;
            for (int j = 0; j < values.length; ++j) {
                buffer.append(sep);
                buffer.append(name);
                buffer.append("=");
                buffer.append(this.encode(values[j]));
                sep = "&";
            }
        }
    }

    private String encode(String value) {
        try {
            return this._codec.encode(value, this._encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("illegal-encoding", this._encoding), (Throwable)ex);
        }
    }

    public String[] getParameterNames() {
        return this._parameters.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this._parameters.getParameterValues(name);
    }
}

