/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.components;

import java.util.Iterator;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.coerce.ValueConverter;

public abstract class Foreach
extends AbstractComponent {
    private Object _value;
    private int _index;

    protected Iterator getSourceData() {
        Object source = null;
        IBinding sourceBinding = this.getBinding("source");
        if (sourceBinding != null) {
            source = sourceBinding.getObject();
        }
        if (source == null) {
            return null;
        }
        return (Iterator)this.getValueConverter().coerceValue(source, Iterator.class);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        this._value = null;
        this._index = 0;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._value = null;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Iterator dataSource = this.getSourceData();
        if (dataSource == null) {
            return;
        }
        boolean indexBound = this.isParameterBound("index");
        boolean valueBound = this.isParameterBound("value");
        String element = this.getElement();
        boolean hasNext = dataSource.hasNext();
        while (hasNext) {
            this._value = dataSource.next();
            hasNext = dataSource.hasNext();
            if (indexBound) {
                this.setIndexParameter(this._index);
            }
            if (valueBound) {
                this.setValueParameter(this._value);
            }
            if (element != null) {
                writer.begin(element);
                this.renderInformalParameters(writer, cycle);
            }
            this.renderBody(writer, cycle);
            if (element != null) {
                writer.end();
            }
            ++this._index;
        }
    }

    public Object getValue() {
        if (!this.isRendering()) {
            throw Tapestry.createRenderOnlyPropertyException(this, "value");
        }
        return this._value;
    }

    public int getIndex() {
        if (!this.isRendering()) {
            throw Tapestry.createRenderOnlyPropertyException(this, "index");
        }
        return this._index;
    }

    public abstract String getElement();

    public abstract void setIndexParameter(int var1);

    public abstract void setValueParameter(Object var1);

    public abstract ValueConverter getValueConverter();
}

