/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.binding;

import org.apache.hivemind.Location;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.binding.BindingMessages;
import org.apache.tapestry.coerce.ValueConverter;

public abstract class AbstractBinding
implements IBinding {
    private final String _description;
    private final ValueConverter _valueConverter;
    private final Location _location;

    protected AbstractBinding(String description, ValueConverter valueConverter, Location location) {
        Defense.notNull((Object)description, (String)"description");
        Defense.notNull((Object)valueConverter, (String)"valueConverter");
        this._description = description;
        this._valueConverter = valueConverter;
        this._location = location;
    }

    public Location getLocation() {
        return this._location;
    }

    public void setObject(Object value) {
        throw this.createReadOnlyBindingException(this);
    }

    public boolean isInvariant() {
        return true;
    }

    public Object getObject(Class type) {
        Defense.notNull((Object)type, (String)"type");
        Object raw = this.getObject();
        try {
            return this._valueConverter.coerceValue(raw, type);
        }
        catch (Exception ex) {
            String message = BindingMessages.convertObjectError(this, ex);
            throw new BindingException(message, this.getComponent(), this._location, this, ex);
        }
    }

    public Object getComponent() {
        return null;
    }

    protected BindingException createReadOnlyBindingException(IBinding binding) {
        return new BindingException(BindingMessages.readOnlyBinding(binding), binding);
    }

    public String getDescription() {
        return this._description;
    }

    public ValueConverter getValueConverter() {
        return this._valueConverter;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append("[");
        buffer.append(this._description);
        this.extendDescription(buffer);
        buffer.append(", location=");
        buffer.append(this._location);
        buffer.append("]");
        return buffer.toString();
    }

    protected void extendDescription(StringBuffer buffer) {
    }
}

