/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.IOUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.asset.AssetComparator;
import org.apache.tapestry.asset.AssetMessages;
import org.apache.tapestry.asset.ResourceDigestSource;
import org.apache.tapestry.asset.ResourceMatcher;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.error.RequestExceptionReporter;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.services.LinkFactory;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebContext;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebResponse;

public class AssetService
implements IEngineService,
ResetEventListener {
    public static final String PATH = "path";
    public static final String DIGEST = "digest";
    private static final Map _mimeTypes = new HashMap(17);
    private static final int BUFFER_SIZE = 10240;
    private static final DateFormat CACHED_FORMAT;
    private ClassResolver _classResolver;
    private LinkFactory _linkFactory;
    private WebContext _context;
    private WebRequest _request;
    private WebResponse _response;
    private ResourceDigestSource _digestSource;
    private ResourceMatcher _unprotectedMatcher;
    private final long _startupTime = System.currentTimeMillis();
    private final long _expireTime = this._startupTime + 31536000000L;
    private RequestExceptionReporter _exceptionReporter;
    private long _lastResetTime = -1L;

    public void resetEventDidOccur() {
        this._lastResetTime = System.currentTimeMillis();
    }

    public ILink getLink(boolean post, Object parameter) {
        Defense.isAssignable((Object)parameter, String.class, (String)"parameter");
        String path = (String)parameter;
        String digest = null;
        if (!this._unprotectedMatcher.containsResource(path)) {
            digest = this._digestSource.getDigestForResource(path);
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>(new AssetComparator());
        parameters.put("service", this.getName());
        parameters.put(PATH, path);
        if (digest != null) {
            parameters.put(DIGEST, digest);
        }
        return this._linkFactory.constructLink(this, post, parameters, false);
    }

    public String getName() {
        return "asset";
    }

    private String getMimeType(String path) {
        String result = this._context.getMimeType(path);
        if (result == null) {
            int dotx = path.lastIndexOf(46);
            if (dotx > -1) {
                String key = path.substring(dotx + 1).toLowerCase();
                result = (String)_mimeTypes.get(key);
            }
            if (result == null) {
                result = "text/plain";
            }
        }
        return result;
    }

    public void service(IRequestCycle cycle) throws IOException {
        String path = cycle.getParameter(PATH);
        String md5Digest = cycle.getParameter(DIGEST);
        boolean checkDigest = !this._unprotectedMatcher.containsResource(path);
        try {
            if (checkDigest && !this._digestSource.getDigestForResource(path).equals(md5Digest)) {
                this._response.sendError(403, AssetMessages.md5Mismatch(path));
                return;
            }
            if (checkDigest && this._request.getHeader("If-Modified-Since") != null) {
                this._response.setStatus(304);
                return;
            }
            URL resourceURL = this._classResolver.getResource(this.translatePath(path));
            if (resourceURL == null) {
                throw new ApplicationRuntimeException(AssetMessages.noSuchResource(path));
            }
            if (!checkDigest && this.cachedResource(resourceURL)) {
                return;
            }
            URLConnection resourceConnection = resourceURL.openConnection();
            this.writeAssetContent(cycle, path, resourceConnection);
        }
        catch (Throwable ex) {
            this._exceptionReporter.reportRequestException(AssetMessages.exceptionReportTitle(path), ex);
        }
    }

    String translatePath(String path) {
        if (path == null) {
            return null;
        }
        String ret = FilenameUtils.normalize((String)path);
        if ((ret = FilenameUtils.separatorsToUnix((String)ret)).endsWith(".css")) {
            return ret;
        }
        int index = ret.lastIndexOf(".css");
        if (index <= -1) {
            return ret;
        }
        int pathEnd = ret.lastIndexOf("/", index);
        if (pathEnd <= -1) {
            return ret;
        }
        return ret.substring(0, pathEnd + 1) + ret.substring(index + 4, ret.length());
    }

    boolean cachedResource(URL resourceURL) {
        File resource = new File(resourceURL.getFile());
        if (!resource.exists()) {
            return false;
        }
        String header = this._request.getHeader("If-Modified-Since");
        long modify = -1L;
        try {
            if (header != null) {
                modify = CACHED_FORMAT.parse(header).getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (resource.lastModified() > modify || this._lastResetTime > modify) {
            return false;
        }
        this._response.setStatus(304);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAssetContent(IRequestCycle cycle, String resourcePath, URLConnection resourceConnection) throws IOException {
        BufferedInputStream input = null;
        try {
            int bytesRead;
            String contentType = this.getMimeType(resourcePath);
            int contentLength = resourceConnection.getContentLength();
            if (contentLength > 0) {
                this._response.setContentLength(contentLength);
            }
            this._response.setDateHeader("Last-Modified", this._startupTime);
            this._response.setDateHeader("Expires", this._expireTime);
            if (contentType == null || contentType.length() == 0) {
                contentType = this.getMimeType(resourcePath);
            }
            OutputStream output = this._response.getOutputStream(new ContentType(contentType));
            input = new BufferedInputStream(resourceConnection.getInputStream());
            byte[] buffer = new byte[10240];
            while ((bytesRead = ((InputStream)input).read(buffer)) >= 0) {
                output.write(buffer, 0, bytesRead);
            }
            ((InputStream)input).close();
            input = null;
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((InputStream)input);
    }

    public void setExceptionReporter(RequestExceptionReporter exceptionReporter) {
        this._exceptionReporter = exceptionReporter;
    }

    public void setLinkFactory(LinkFactory linkFactory) {
        this._linkFactory = linkFactory;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setContext(WebContext context) {
        this._context = context;
    }

    public void setResponse(WebResponse response) {
        this._response = response;
    }

    public void setDigestSource(ResourceDigestSource md5Source) {
        this._digestSource = md5Source;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void setUnprotectedMatcher(ResourceMatcher matcher) {
        this._unprotectedMatcher = matcher;
    }

    static {
        _mimeTypes.put("css", "text/css");
        _mimeTypes.put("gif", "image/gif");
        _mimeTypes.put("jpg", "image/jpeg");
        _mimeTypes.put("jpeg", "image/jpeg");
        _mimeTypes.put("htm", "text/html");
        _mimeTypes.put("html", "text/html");
        CACHED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    }
}

