/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.event.ChangeObserver;
import org.apache.tapestry.event.ObservedChangeEvent;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.StringSplitter;

public final class Tapestry {
    public static final String ACTION_SERVICE = "action";
    public static final String DIRECT_SERVICE = "direct";
    public static final String DIRECT_EVENT_SERVICE = "directevent";
    public static final String EXTERNAL_SERVICE = "external";
    public static final String PAGE_SERVICE = "page";
    public static final String HOME_SERVICE = "home";
    public static final String RESTART_SERVICE = "restart";
    public static final String ASSET_SERVICE = "asset";
    public static final String RESET_SERVICE = "reset";
    public static final String SERVICE_QUERY_PARAMETER_NAME = "service";
    public static final String PARAMETERS_QUERY_PARAMETER_NAME = "sp";
    public static final String TEMPLATE_EXTENSION_PROPERTY = "org.apache.tapestry.template-extension";
    public static final String LINK_COMPONENT_ATTRIBUTE_NAME = "org.apache.tapestry.active-link-component";
    public static final String PARAMETER_PROPERTY_NAME_SUFFIX = "Binding";
    public static final String REQUEST_DECODER_EXTENSION_NAME = "org.apache.tapestry.request-decoder";
    public static final String MULTIPART_DECODER_EXTENSION_NAME = "org.apache.tapestry.multipart-decoder";
    public static final String ABSTRACTPAGE_VALIDATE_METHOD_ID = "AbstractPage.validate()";
    public static final String ABSTRACTPAGE_DETACH_METHOD_ID = "AbstractPage.detach()";
    public static final String SIMPLE_PROPERTY_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String MONITOR_FACTORY_EXTENSION_NAME = "org.apache.tapestry.monitor-factory";
    public static final String OGNL_TYPE_CONVERTER = "org.apache.tapestry.ognl-type-converter";
    public static final String VERSION = Tapestry.readVersion();
    private static final String UNKNOWN_VERSION = "Unknown";
    private static ResourceBundle _strings;
    private static final Map _localeMap;
    private static final ThreadLocal _invokedMethodIds;

    private Tapestry() {
    }

    public static void copyInformalBindings(IComponent source, IComponent destination) {
        Collection names = source.getBindingNames();
        if (names == null) {
            return;
        }
        IComponentSpecification specification = source.getSpecification();
        for (String name : names) {
            if (specification.getParameter(name) != null) continue;
            IBinding binding = source.getBinding(name);
            destination.setBinding(name, binding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale(String s) {
        Locale result = null;
        Map map = _localeMap;
        synchronized (map) {
            result = (Locale)_localeMap.get(s);
        }
        if (result == null) {
            StringSplitter splitter = new StringSplitter('_');
            String[] terms = splitter.splitToArray(s);
            switch (terms.length) {
                case 1: {
                    result = new Locale(terms[0], "");
                    break;
                }
                case 2: {
                    result = new Locale(terms[0], terms[1]);
                    break;
                }
                case 3: {
                    result = new Locale(terms[0], terms[1], terms[2]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to convert '" + s + "' to a Locale.");
                }
            }
            Map map2 = _localeMap;
            synchronized (map2) {
                _localeMap.put(s, result);
            }
        }
        return result;
    }

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String format(String key, Object[] args) {
        if (_strings == null) {
            _strings = ResourceBundle.getBundle("org.apache.tapestry.TapestryStrings");
        }
        String pattern = _strings.getString(key);
        if (args == null) {
            return pattern;
        }
        return MessageFormat.format(pattern, args);
    }

    public static String getMessage(String key) {
        return Tapestry.format(key, null);
    }

    public static String format(String key, Object arg) {
        return Tapestry.format(key, new Object[]{arg});
    }

    public static String format(String key, Object arg1, Object arg2) {
        return Tapestry.format(key, new Object[]{arg1, arg2});
    }

    public static String format(String key, Object arg1, Object arg2, Object arg3) {
        return Tapestry.format(key, new Object[]{arg1, arg2, arg3});
    }

    private static String readVersion() {
        Properties props = new Properties();
        try {
            InputStream in = Tapestry.class.getResourceAsStream("version.properties");
            if (in == null) {
                return UNKNOWN_VERSION;
            }
            props.load(in);
            in.close();
            return props.getProperty("project.version", UNKNOWN_VERSION);
        }
        catch (IOException ex) {
            return UNKNOWN_VERSION;
        }
    }

    public static int size(Collection c) {
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    public static int size(Object[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static Object[] convertMapToArray(Map map) {
        if (Tapestry.isEmpty(map)) {
            return null;
        }
        Set entries = map.entrySet();
        Object[] result = new Object[2 * entries.size()];
        int x = 0;
        for (Map.Entry entry : entries) {
            result[x++] = entry.getKey();
            result[x++] = entry.getValue();
        }
        return result;
    }

    public static Map convertArrayToMap(Object[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException(Tapestry.getMessage("Tapestry.even-sized-array"));
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        int x = 0;
        while (x < array.length) {
            Object key = array[x++];
            Object value = array[x++];
            result.put(key, value);
        }
        return result;
    }

    public static String getClassName(Class subject) {
        return ClassFabUtils.getJavaClassName((Class)subject);
    }

    public static BindingException createNullBindingException(IBinding binding) {
        return new BindingException(Tapestry.getMessage("null-value-for-binding"), binding);
    }

    public static ApplicationRuntimeException createNoSuchComponentException(IComponent component, String id, Location location) {
        return new ApplicationRuntimeException(Tapestry.format("no-such-component", component.getExtendedId(), id), (Object)component, location, null);
    }

    public static BindingException createRequiredParameterException(IComponent component, String parameterName) {
        return new BindingException(Tapestry.format("required-parameter", parameterName, component.getExtendedId()), component, null, component.getBinding(parameterName), null);
    }

    public static ApplicationRuntimeException createRenderOnlyPropertyException(IComponent component, String propertyName) {
        return new ApplicationRuntimeException(Tapestry.format("render-only-property", propertyName, component.getExtendedId()), (Object)component, null, null);
    }

    public static void clearMethodInvocations() {
        _invokedMethodIds.set(null);
    }

    public static void addMethodInvocation(Object methodId) {
        ArrayList<Object> methodIds = (ArrayList<Object>)_invokedMethodIds.get();
        if (methodIds == null) {
            methodIds = new ArrayList<Object>();
            _invokedMethodIds.set(methodIds);
        }
        methodIds.add(methodId);
    }

    public static void checkMethodInvocation(Object methodId, String methodName, Object object) {
        List methodIds = (List)_invokedMethodIds.get();
        if (methodIds != null && methodIds.contains(methodId)) {
            return;
        }
        throw new ApplicationRuntimeException(Tapestry.format("Tapestry.missing-method-invocation", object.getClass().getName(), methodName));
    }

    public static void fireObservedChange(IComponent component, String propertyName, Object newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, newValue);
        observer.observeChange(event);
    }

    public static boolean isBlank(String input) {
        return HiveMind.isBlank((String)input);
    }

    public static boolean isNonBlank(String input) {
        return HiveMind.isNonBlank((String)input);
    }

    static {
        _localeMap = new HashMap();
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            _localeMap.put(locales[i].toString(), locales[i]);
        }
        _invokedMethodIds = new ThreadLocal();
    }
}

