/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.event.ChangeObserver;
import org.apache.tapestry.event.PageAttachListener;
import org.apache.tapestry.event.PageBeginRenderListener;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEndRenderListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageValidateListener;
import org.apache.tapestry.services.ResponseBuilder;
import org.apache.tapestry.util.StringSplitter;

public abstract class AbstractPage
extends BaseComponent
implements IPage {
    private static final Log LOG = LogFactory.getLog(AbstractPage.class);
    private ChangeObserver _changeObserver;
    private IEngine _engine;
    private String _pageName;
    private IRequestCycle _requestCycle;
    private Locale _locale;
    private EventListenerList _listenerList;
    private String _outputEncoding;

    public void detach() {
        Tapestry.addMethodInvocation("AbstractPage.detach()");
        this._changeObserver = null;
        this.firePageDetached();
        this._engine = null;
        this._requestCycle = null;
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public ChangeObserver getChangeObserver() {
        return this._changeObserver;
    }

    public String getExtendedId() {
        return this._pageName;
    }

    public String getIdPath() {
        return null;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale value) {
        if (this._locale != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractPage.attempt-to-change-locale"));
        }
        this._locale = value;
    }

    public IComponent getNestedComponent(String path) {
        if (path == null) {
            return this;
        }
        StringSplitter splitter = new StringSplitter('.');
        IComponent current = this;
        String[] elements = splitter.splitToArray(path);
        for (int i = 0; i < elements.length; ++i) {
            current = current.getComponent(elements[i]);
        }
        return current;
    }

    public void attach(IEngine engine, IRequestCycle cycle) {
        if (this._engine != null) {
            LOG.error((Object)(this + " attach(" + engine + "), but engine = " + this._engine));
        }
        this._engine = engine;
        this._requestCycle = cycle;
        this.firePageAttached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(ResponseBuilder builder, IRequestCycle cycle) {
        try {
            this.firePageBeginRender();
            this.beginResponse(cycle.isRewinding() ? NullWriter.getSharedInstance() : builder.getWriter(), cycle);
            if (!cycle.isRewinding()) {
                cycle.commitPageChanges();
            }
            builder.render(cycle.isRewinding() ? NullWriter.getSharedInstance() : null, this, cycle);
        }
        finally {
            this.firePageEndRender();
        }
    }

    public void setChangeObserver(ChangeObserver value) {
        this._changeObserver = value;
    }

    public void setPageName(String pageName) {
        if (this._pageName != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("AbstractPage.attempt-to-change-name"));
        }
        this._pageName = pageName;
    }

    public void validate(IRequestCycle cycle) {
        Tapestry.addMethodInvocation("AbstractPage.validate()");
        this.firePageValidate();
    }

    public void beginResponse(IMarkupWriter writer, IRequestCycle cycle) {
    }

    public IRequestCycle getRequestCycle() {
        return this._requestCycle;
    }

    public void addPageDetachListener(PageDetachListener listener) {
        this.addListener(PageDetachListener.class, listener);
    }

    private void addListener(Class listenerClass, EventListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(listenerClass, listener);
    }

    private void removeListener(Class listenerClass, EventListener listener) {
        if (this._listenerList != null) {
            this._listenerList.remove(listenerClass, listener);
        }
    }

    public void addPageBeginRenderListener(PageBeginRenderListener listener) {
        this.addListener(PageBeginRenderListener.class, listener);
    }

    public void addPageEndRenderListener(PageEndRenderListener listener) {
        this.addListener(PageEndRenderListener.class, listener);
    }

    public void removePageBeginRenderListener(PageBeginRenderListener listener) {
        this.removeListener(PageBeginRenderListener.class, listener);
    }

    public void removePageEndRenderListener(PageEndRenderListener listener) {
        this.removeListener(PageEndRenderListener.class, listener);
    }

    public void firePageAttached() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PageAttachListener.class) continue;
            PageAttachListener l = (PageAttachListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageAttached(event);
        }
    }

    protected void firePageDetached() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PageDetachListener.class) continue;
            PageDetachListener l = (PageDetachListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageDetached(event);
        }
    }

    protected void firePageBeginRender() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PageBeginRenderListener.class) continue;
            PageBeginRenderListener l = (PageBeginRenderListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageBeginRender(event);
        }
    }

    protected void firePageEndRender() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PageEndRenderListener.class) continue;
            PageEndRenderListener l = (PageEndRenderListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageEndRender(event);
        }
    }

    public void removePageDetachListener(PageDetachListener listener) {
        this.removeListener(PageDetachListener.class, listener);
    }

    public void beginPageRender() {
        this.firePageBeginRender();
    }

    public void endPageRender() {
        this.firePageEndRender();
    }

    public String getPageName() {
        return this._pageName;
    }

    public void addPageValidateListener(PageValidateListener listener) {
        this.addListener(PageValidateListener.class, listener);
    }

    public void removePageValidateListener(PageValidateListener listener) {
        this.removeListener(PageValidateListener.class, listener);
    }

    public void addPageAttachListener(PageAttachListener listener) {
        this.addListener(PageAttachListener.class, listener);
    }

    public void removePageAttachListener(PageAttachListener listener) {
        this.removeListener(PageAttachListener.class, listener);
    }

    protected void firePageValidate() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PageValidateListener.class) continue;
            PageValidateListener l = (PageValidateListener)listeners[i + 1];
            if (event == null) {
                event = new PageEvent(this, this._requestCycle);
            }
            l.pageValidate(event);
        }
    }

    protected String getOutputEncoding() {
        if (this._outputEncoding == null) {
            this._outputEncoding = this.getEngine().getOutputEncoding();
        }
        return this._outputEncoding;
    }
}

