// Copyright 2004, 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.event;

/**
 * An object that listens to page events. The
 * {@link org.apache.tapestry.IPage page}generates events before and after
 * rendering a response. These events also occur before and after a form
 * rewinds.
 * 
 * @author Howard Lewis Ship
 * @since 1.0.5
 * @deprecated To be removed in 4.1. Use
 *             {@link org.apache.tapestry.event.PageBeginRenderListener} and/or
 *             {@link org.apache.tapestry.event.PageEndRenderListener}.
 */

public interface PageRenderListener extends PageBeginRenderListener,
        PageEndRenderListener
{
}
