// Copyright 2004, 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.asset;

import java.io.InputStream;
import java.net.URL;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.tapestry.Tapestry;

/**
 *  A reference to an external URL.  {@link ExternalAsset}s are not
 *  localizable.
 *
 *  @author Howard Lewis Ship
 * 
 **/

public class ExternalAsset extends AbstractAsset
{
    private String _url;

    public ExternalAsset(String URL, Location location)
    {
        super(null, location);

        _url = URL;
    }

    /**
     *  Simply returns the URL of the external asset.
     *
     **/

    public String buildURL()
    {
        return _url;
    }

    public InputStream getResourceAsStream()
    {
        URL url;

        try
        {
            url = new URL(_url);

            return url.openStream();
        }
        catch (Exception ex)
        {
            // MalrformedURLException or IOException

            throw new ApplicationRuntimeException(Tapestry.format("ExternalAsset.resource-missing", _url), ex);
        }

    }

    public String toString()
    {
        return "ExternalAsset[" + _url + "]";
    }
}
