/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import org.apache.tapestry5.plastic.AnnotationAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingAnnotationAccess
implements AnnotationAccess {
    private final AnnotationAccess primary;
    private final AnnotationAccess inherited;

    public DelegatingAnnotationAccess(AnnotationAccess primary, AnnotationAccess inherited) {
        this.primary = primary;
        this.inherited = inherited;
    }

    private boolean isInherited(Class<? extends Annotation> annotationType) {
        return annotationType.getAnnotation(Inherited.class) != null;
    }

    @Override
    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        if (this.primary.hasAnnotation(annotationType)) {
            return true;
        }
        return this.isInherited(annotationType) && this.inherited.hasAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        T fromPrimary = this.primary.getAnnotation(annotationType);
        if (fromPrimary != null) {
            return fromPrimary;
        }
        return this.isInherited(annotationType) ? (T)this.inherited.getAnnotation(annotationType) : null;
    }
}

