/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Optional;
import org.apache.syncope.common.lib.clientapps.AnonymousUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.DefaultUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.GroovyUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.PairwiseOidcUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.PrincipalAttributeUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.UsernameAttributeProviderConf;
import org.apereo.cas.authentication.principal.OidcPairwisePersistentIdGenerator;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.GroovyRegisteredServiceUsernameProvider;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.util.RandomUtils;

public class DefaultUsernameAttributeProviderConfMapper
implements UsernameAttributeProviderConf.Mapper {
    protected final BaseWebBasedRegisteredService service;

    protected static Optional<PersistentIdGenerator> toPersistentIdGenerator(org.apache.syncope.common.lib.types.PersistentIdGenerator persistentIdGenerator) {
        if (persistentIdGenerator == null) {
            return Optional.empty();
        }
        OidcPairwisePersistentIdGenerator result = null;
        switch (persistentIdGenerator) {
            case SHIBBOLETH: {
                result = new ShibbolethCompatiblePersistentIdGenerator(RandomUtils.randomAlphanumeric((int)16));
                break;
            }
            case OIDC: {
                result = new OidcPairwisePersistentIdGenerator();
                break;
            }
        }
        return Optional.ofNullable(result);
    }

    public DefaultUsernameAttributeProviderConfMapper(BaseWebBasedRegisteredService service) {
        this.service = service;
    }

    public void map(AnonymousUsernameAttributeProviderConf conf) {
        AnonymousRegisteredServiceUsernameAttributeProvider provider = new AnonymousRegisteredServiceUsernameAttributeProvider();
        DefaultUsernameAttributeProviderConfMapper.toPersistentIdGenerator(conf.getPersistentIdGenerator()).ifPresent(arg_0 -> ((AnonymousRegisteredServiceUsernameAttributeProvider)provider).setPersistentIdGenerator(arg_0));
        provider.setCanonicalizationMode(conf.getCaseCanonicalizationMode().name());
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider);
    }

    public void map(DefaultUsernameAttributeProviderConf conf) {
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        provider.setCanonicalizationMode(conf.getCaseCanonicalizationMode().name());
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider);
    }

    public void map(GroovyUsernameAttributeProviderConf conf) {
        GroovyRegisteredServiceUsernameProvider provider = new GroovyRegisteredServiceUsernameProvider(conf.getGroovyScript());
        provider.setCanonicalizationMode(conf.getCaseCanonicalizationMode().name());
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider);
    }

    public void map(PairwiseOidcUsernameAttributeProviderConf conf) {
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        DefaultUsernameAttributeProviderConfMapper.toPersistentIdGenerator(conf.getPersistentIdGenerator()).ifPresent(arg_0 -> ((PairwiseOidcRegisteredServiceUsernameAttributeProvider)provider).setPersistentIdGenerator(arg_0));
        provider.setCanonicalizationMode(conf.getCaseCanonicalizationMode().name());
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider);
    }

    public void map(PrincipalAttributeUsernameAttributeProviderConf conf) {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider(conf.getUsernameAttribute());
        provider.setCanonicalizationMode(conf.getCaseCanonicalizationMode().name());
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider);
    }
}

