/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.list;

import java.util.List;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.model.IModel;

public abstract class PageableListView<T>
extends ListView<T>
implements IPageableItems {
    private static final long serialVersionUID = 1L;
    private long currentPage;
    private long itemsPerPage;

    public PageableListView(String id, IModel<? extends List<? extends T>> model, int itemsPerPage) {
        super(id, model);
        this.itemsPerPage = itemsPerPage;
    }

    public PageableListView(String id, List<? extends T> list, int itemsPerPage) {
        super(id, list);
        this.itemsPerPage = itemsPerPage;
    }

    @Override
    public final long getCurrentPage() {
        while (this.currentPage > 0L && this.currentPage * this.itemsPerPage >= this.getItemCount()) {
            --this.currentPage;
        }
        return this.currentPage;
    }

    @Override
    public final long getPageCount() {
        return (this.getItemCount() + this.itemsPerPage - 1L) / this.itemsPerPage;
    }

    @Override
    public final long getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public final void setItemsPerPage(long itemsPerPage) {
        if (itemsPerPage < 0L) {
            itemsPerPage = 0L;
        }
        this.addStateChange();
        this.itemsPerPage = itemsPerPage;
    }

    public long getFirstItemOffset() {
        return this.getCurrentPage() * this.getItemsPerPage();
    }

    @Override
    public long getItemCount() {
        return this.getList().size();
    }

    @Override
    public int getViewSize() {
        if (this.getDefaultModelObject() != null) {
            super.setStartIndex((int)this.getFirstItemOffset());
            super.setViewSize((int)this.getItemsPerPage());
        }
        return super.getViewSize();
    }

    @Override
    public final void setCurrentPage(long currentPage) {
        if (currentPage < 0L) {
            currentPage = 0L;
        }
        long pageCount = this.getPageCount();
        if (currentPage > 0L && currentPage >= pageCount) {
            currentPage = pageCount - 1L;
        }
        this.addStateChange();
        this.currentPage = currentPage;
    }

    @Override
    public ListView<T> setStartIndex(int startIndex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("You must not use setStartIndex() with PageableListView");
    }

    @Override
    public ListView<T> setViewSize(int size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("You must not use setViewSize() with PageableListView");
    }
}

