/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.mount.MountMapper;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;

public class BookmarkableMapper
extends AbstractBookmarkableMapper {
    private final IPageParametersEncoder pageParametersEncoder;

    public BookmarkableMapper(IPageParametersEncoder pageParametersEncoder) {
        Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.pageParametersEncoder = pageParametersEncoder;
    }

    public BookmarkableMapper() {
        this((IPageParametersEncoder)new PageParametersEncoder());
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        url.getSegments().add(this.getContext().getNamespace());
        url.getSegments().add(this.getContext().getBookmarkableIdentifier());
        url.getSegments().add(info.getPageClass().getName());
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        if (this.matches(request)) {
            Url url = request.getUrl();
            PageComponentInfo info = this.getPageComponentInfo(url);
            List segments = url.getSegments();
            String className = segments.size() >= 3 ? (String)segments.get(2) : (String)segments.get(1);
            Class<? extends IRequestablePage> pageClass = this.getPageClass(className);
            if (pageClass != null && IRequestablePage.class.isAssignableFrom(pageClass)) {
                Application application;
                if (Application.exists() && (application = Application.get()).getSecuritySettings().getEnforceMounts() && !pageClass.equals(application.getHomePage()) && this.isPageMounted(pageClass, application)) {
                    return null;
                }
                PageParameters pageParameters = this.extractPageParameters(request, 3, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    private boolean isPageMounted(Class<? extends IRequestablePage> pageClass, Application application) {
        ICompoundRequestMapper applicationMappers = application.getRootRequestMapperAsCompound();
        for (IRequestMapper requestMapper : applicationMappers) {
            AbstractBookmarkableMapper mapper;
            if (requestMapper instanceof MountMapper) {
                MountMapper mountMapper = (MountMapper)requestMapper;
                requestMapper = mountMapper.getInnerRequestMapper();
            }
            if (!(requestMapper instanceof AbstractBookmarkableMapper) || requestMapper == this || !(mapper = (AbstractBookmarkableMapper)requestMapper).checkPageClass(pageClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = 0;
        if (this.matches(request)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Request request) {
        boolean matches = false;
        Url url = request.getUrl();
        Url baseUrl = request.getClientUrl();
        String namespace = this.getContext().getNamespace();
        String bookmarkableIdentifier = this.getContext().getBookmarkableIdentifier();
        String pageIdentifier = this.getContext().getPageIdentifier();
        if (url.getSegments().size() >= 3 && this.urlStartsWith(url, new String[]{namespace, bookmarkableIdentifier})) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 3 && this.urlStartsWith(baseUrl, new String[]{namespace, bookmarkableIdentifier}) && url.getSegments().size() >= 2 && this.urlStartsWith(url, new String[]{bookmarkableIdentifier})) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, new String[]{bookmarkableIdentifier}) && url.getSegments().size() == 2 && this.urlStartsWith(url, new String[]{bookmarkableIdentifier})) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, new String[]{namespace, pageIdentifier}) && url.getSegments().size() >= 2 && this.urlStartsWith(url, new String[]{bookmarkableIdentifier})) {
            matches = true;
        }
        return matches;
    }
}

