/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.mod.AbstractAttributableMod;
import org.apache.syncope.common.mod.AttributeMod;
import org.apache.syncope.common.mod.MembershipMod;
import org.apache.syncope.common.mod.ReferenceMod;
import org.apache.syncope.common.mod.RoleMod;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;

public final class AttributableOperations {
    private AttributableOperations() {
    }

    private static void populate(Map<String, AttributeTO> updatedAttrs, Map<String, AttributeTO> originalAttrs, AbstractAttributableMod result) {
        AttributableOperations.populate(updatedAttrs, originalAttrs, result, false);
    }

    private static void populate(Map<String, AttributeTO> updatedAttrs, Map<String, AttributeTO> originalAttrs, AbstractAttributableMod result, boolean virtuals) {
        for (Map.Entry<String, AttributeTO> entry : updatedAttrs.entrySet()) {
            HashSet<String> originalValues;
            AttributeMod mod = new AttributeMod();
            mod.setSchema(entry.getKey());
            HashSet<String> updatedValues = new HashSet<String>(entry.getValue().getValues());
            HashSet<String> hashSet = originalValues = originalAttrs.containsKey(entry.getKey()) ? new HashSet<String>(originalAttrs.get(entry.getKey()).getValues()) : Collections.emptySet();
            if (!originalAttrs.containsKey(entry.getKey())) {
                updatedValues.remove("");
                mod.setValuesToBeAdded(new ArrayList<String>(updatedValues));
                if (virtuals) {
                    result.addVirtualAttributeToBeUpdated(mod);
                    continue;
                }
                result.addAttributeToBeUpdated(mod);
                continue;
            }
            if (updatedValues.equals(originalValues)) continue;
            updatedValues.remove("");
            if (!entry.getValue().isReadonly()) {
                mod.setValuesToBeAdded(new ArrayList<String>(updatedValues));
                if (!mod.isEmpty()) {
                    if (virtuals) {
                        result.addVirtualAttributeToBeRemoved(mod.getSchema());
                    } else {
                        result.addAttributeToBeRemoved(mod.getSchema());
                    }
                }
            }
            mod.setValuesToBeRemoved(new ArrayList<String>(originalValues));
            if (mod.isEmpty()) continue;
            if (virtuals) {
                result.addVirtualAttributeToBeUpdated(mod);
                continue;
            }
            result.addAttributeToBeUpdated(mod);
        }
    }

    private static void diff(AbstractAttributableTO updated, AbstractAttributableTO original, AbstractAttributableMod result, boolean incremental) {
        if (updated.getId() != original.getId()) {
            throw new IllegalArgumentException("AttributableTO's id must be the same");
        }
        result.setId(updated.getId());
        Map<String, AttributeTO> updatedAttrs = new HashMap<String, AttributeTO>(updated.getAttributeMap());
        Map<String, AttributeTO> originalAttrs = new HashMap<String, AttributeTO>(original.getAttributeMap());
        HashSet<String> originalAttrNames = new HashSet<String>(originalAttrs.keySet());
        originalAttrNames.removeAll(updatedAttrs.keySet());
        if (!incremental) {
            result.setAttributesToBeRemoved(originalAttrNames);
        }
        HashSet emptyUpdatedAttrs = new HashSet();
        for (Map.Entry entry : updatedAttrs.entrySet()) {
            if (((AttributeTO)entry.getValue()).getValues() != null && !((AttributeTO)entry.getValue()).getValues().isEmpty()) continue;
            emptyUpdatedAttrs.add(entry.getKey());
        }
        for (String emptyUpdatedAttr : emptyUpdatedAttrs) {
            updatedAttrs.remove(emptyUpdatedAttr);
            result.addAttributeToBeRemoved(emptyUpdatedAttr);
        }
        AttributableOperations.populate(updatedAttrs, originalAttrs, result);
        updatedAttrs = updated.getDerivedAttributeMap();
        originalAttrs = original.getDerivedAttributeMap();
        originalAttrNames = new HashSet<String>(originalAttrs.keySet());
        originalAttrNames.removeAll(updatedAttrs.keySet());
        if (!incremental) {
            result.setDerivedAttributesToBeRemoved(originalAttrNames);
        }
        HashSet<String> updatedAttrNames = new HashSet<String>(updatedAttrs.keySet());
        updatedAttrNames.removeAll(originalAttrs.keySet());
        result.setDerivedAttributesToBeAdded(updatedAttrNames);
        updatedAttrs = updated.getVirtualAttributeMap();
        originalAttrs = original.getVirtualAttributeMap();
        originalAttrNames = new HashSet<String>(originalAttrs.keySet());
        originalAttrNames.removeAll(updatedAttrs.keySet());
        if (!incremental) {
            result.setVirtualAttributesToBeRemoved(originalAttrNames);
        }
        AttributableOperations.populate(updatedAttrs, originalAttrs, result, true);
        HashSet<String> updatedRes = new HashSet<String>(updated.getResources());
        HashSet<String> originalRes = new HashSet<String>(original.getResources());
        updatedRes.removeAll(originalRes);
        result.setResourcesToBeAdded(updatedRes);
        originalRes.removeAll(updated.getResources());
        if (!incremental) {
            result.setResourcesToBeRemoved(originalRes);
        }
    }

    public static UserMod diff(UserTO updated, UserTO original) {
        return AttributableOperations.diff(updated, original, false);
    }

    public static UserMod diff(UserTO updated, UserTO original, boolean incremental) {
        UserMod result = new UserMod();
        AttributableOperations.diff(updated, original, result, incremental);
        if (original.getPassword() != null && !original.getPassword().equals(updated.getPassword())) {
            result.setPassword(updated.getPassword());
        }
        if (original.getUsername() != null && !original.getUsername().equals(updated.getUsername())) {
            result.setUsername(updated.getUsername());
        }
        Map<Long, MembershipTO> updatedMembs = updated.getMembershipMap();
        Map<Long, MembershipTO> originalMembs = original.getMembershipMap();
        for (Map.Entry<Long, MembershipTO> entry : updatedMembs.entrySet()) {
            MembershipMod membMod = new MembershipMod();
            membMod.setRole(entry.getValue().getRoleId());
            if (originalMembs.containsKey(entry.getKey())) {
                AttributableOperations.diff(entry.getValue(), originalMembs.get(entry.getKey()), membMod, false);
            } else {
                AttributeMod attrMod;
                for (AttributeTO attr : entry.getValue().getAttributes()) {
                    attrMod = new AttributeMod();
                    attrMod.setSchema(attr.getSchema());
                    attrMod.setValuesToBeAdded(attr.getValues());
                    if (attrMod.isEmpty()) continue;
                    membMod.addAttributeToBeUpdated(attrMod);
                    membMod.addAttributeToBeRemoved(attrMod.getSchema());
                }
                for (AttributeTO attr : entry.getValue().getDerivedAttributes()) {
                    membMod.addDerivedAttributeToBeAdded(attr.getSchema());
                }
                for (AttributeTO attr : entry.getValue().getVirtualAttributes()) {
                    attrMod = new AttributeMod();
                    attrMod.setSchema(attr.getSchema());
                    attrMod.setValuesToBeAdded(attr.getValues());
                    if (attrMod.isEmpty()) continue;
                    membMod.addVirtualAttributeToBeUpdated(attrMod);
                    membMod.addAttributeToBeRemoved(attrMod.getSchema());
                }
                membMod.setResourcesToBeAdded(entry.getValue().getResources());
            }
            if (membMod.isEmpty()) continue;
            result.addMembershipToBeAdded(membMod);
        }
        if (!incremental) {
            HashSet<Long> originalRoles = new HashSet<Long>(originalMembs.keySet());
            originalRoles.removeAll(updatedMembs.keySet());
            for (Long roleId : originalRoles) {
                result.addMembershipToBeRemoved(originalMembs.get(roleId).getId());
            }
        }
        return result;
    }

    public static RoleMod diff(RoleTO updated, RoleTO original) {
        return AttributableOperations.diff(updated, original, false);
    }

    public static RoleMod diff(RoleTO updated, RoleTO original, boolean incremental) {
        HashSet<String> originalEnts;
        HashSet<String> updatedEnts;
        RoleMod result = new RoleMod();
        AttributableOperations.diff(updated, original, result, incremental);
        result.setInheritOwner(updated.isInheritOwner());
        result.setInheritAccountPolicy(updated.isInheritAccountPolicy());
        result.setInheritPasswordPolicy(updated.isInheritPasswordPolicy());
        result.setInheritAttributes(updated.isInheritAttributes());
        result.setInheritDerivedAttributes(updated.isInheritDerivedAttributes());
        result.setInheritVirtualAttributes(updated.isInheritVirtualAttributes());
        result.setAccountPolicy(new ReferenceMod(updated.getAccountPolicy()));
        result.setPasswordPolicy(new ReferenceMod(updated.getPasswordPolicy()));
        if (!original.getName().equals(updated.getName())) {
            result.setName(updated.getName());
        }
        if ((updatedEnts = new HashSet<String>(updated.getEntitlements())).equals(originalEnts = new HashSet<String>(original.getEntitlements()))) {
            result.setEntitlements(null);
        } else {
            result.setEntitlements(updated.getEntitlements());
        }
        result.setUserOwner(new ReferenceMod(updated.getUserOwner()));
        result.setRoleOwner(new ReferenceMod(updated.getRoleOwner()));
        return result;
    }

    private static List<AttributeTO> getUpdateValues(Map<String, AttributeTO> attrs, Set<String> attrsToBeRemoved, Set<AttributeMod> attrsToBeUpdated) {
        HashMap<String, AttributeTO> rwattrs = new HashMap<String, AttributeTO>(attrs);
        for (String attrName : attrsToBeRemoved) {
            rwattrs.remove(attrName);
        }
        for (AttributeMod attrMod : attrsToBeUpdated) {
            AttributeTO attrTO;
            if (rwattrs.containsKey(attrMod.getSchema())) {
                attrTO = (AttributeTO)rwattrs.get(attrMod.getSchema());
                attrTO.getValues().removeAll(attrMod.getValuesToBeRemoved());
                attrTO.getValues().addAll(attrMod.getValuesToBeAdded());
                continue;
            }
            attrTO = new AttributeTO();
            attrTO.setSchema(attrMod.getSchema());
            attrTO.setValues(attrMod.getValuesToBeAdded());
            rwattrs.put(attrMod.getSchema(), attrTO);
        }
        return new ArrayList<AttributeTO>(rwattrs.values());
    }

    private static <T extends AbstractAttributableTO, K extends AbstractAttributableMod> void apply(T to, K mod, T result) {
        result.setAttributes(AttributableOperations.getUpdateValues(to.getAttributeMap(), mod.getAttributesToBeRemoved(), mod.getAttributesToBeUpdated()));
        Map<String, AttributeTO> attrs = to.getDerivedAttributeMap();
        for (String attrName : mod.getDerivedAttributesToBeRemoved()) {
            attrs.remove(attrName);
        }
        for (String attrName : mod.getDerivedAttributesToBeAdded()) {
            AttributeTO attrTO = new AttributeTO();
            attrTO.setSchema(attrName);
            attrs.put(attrName, attrTO);
        }
        result.setDerivedAttributes(new ArrayList<AttributeTO>(attrs.values()));
        result.setVirtualAttributes(AttributableOperations.getUpdateValues(to.getVirtualAttributeMap(), mod.getVirtualAttributesToBeRemoved(), mod.getVirtualAttributesToBeUpdated()));
        result.getResources().removeAll(mod.getResourcesToBeRemoved());
        result.getResources().addAll(mod.getResourcesToBeAdded());
    }

    public static UserTO apply(UserTO userTO, UserMod userMod) {
        if (userTO.getId() != userMod.getId()) {
            throw new IllegalArgumentException("UserTO and UserMod ids must be the same");
        }
        UserTO result = (UserTO)SerializationUtils.clone((Serializable)userTO);
        AttributableOperations.apply(userTO, userMod, result);
        result.setPassword(userMod.getPassword());
        if (userMod.getUsername() != null) {
            result.setUsername(userMod.getUsername());
        }
        Map<Long, MembershipTO> membs = result.getMembershipMap();
        for (Long membId : userMod.getMembershipsToBeRemoved()) {
            result.removeMembership(membs.get(membId));
        }
        for (MembershipMod membMod : userMod.getMembershipsToBeAdded()) {
            MembershipTO membTO = new MembershipTO();
            membTO.setRoleId(membMod.getRole());
            AttributableOperations.apply(membTO, membMod, membTO);
        }
        return result;
    }
}

