/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.common.types.ConnectorCapability;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="connector")
@XmlType
public class ConnInstanceTO
extends AbstractBaseBean {
    private static final long serialVersionUID = 2707778645445168671L;
    private long id;
    private String location;
    private String connectorName;
    private String bundleName;
    private String version;
    private final Set<ConnConfProperty> configuration = new HashSet<ConnConfProperty>();
    private final Set<ConnectorCapability> capabilities = EnumSet.noneOf(ConnectorCapability.class);
    private String displayName;
    private Integer connRequestTimeout;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorname) {
        this.connectorName = connectorname;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundlename) {
        this.bundleName = bundlename;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElementWrapper(name="configuration")
    @XmlElement(name="property")
    public Set<ConnConfProperty> getConfiguration() {
        return this.configuration;
    }

    @JsonIgnore
    public Map<String, ConnConfProperty> getConfigurationMap() {
        Map<String, ConnConfProperty> result;
        if (this.getConfiguration() == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            for (ConnConfProperty prop : this.getConfiguration()) {
                result.put(prop.getSchema().getName(), prop);
            }
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    public boolean addConfiguration(ConnConfProperty property) {
        return this.configuration.add(property);
    }

    public boolean removeConfiguration(ConnConfProperty property) {
        return this.configuration.remove(property);
    }

    public void setConfiguration(Set<ConnConfProperty> configuration) {
        if (this.configuration != configuration) {
            this.configuration.clear();
            if (configuration != null && !configuration.isEmpty()) {
                this.configuration.addAll(configuration);
            }
        }
    }

    public boolean addCapability(ConnectorCapability capability) {
        return this.capabilities.add(capability);
    }

    public boolean removeCapability(ConnectorCapability capability) {
        return this.capabilities.remove((Object)capability);
    }

    @XmlElementWrapper(name="capabilities")
    @XmlElement(name="capability")
    public Set<ConnectorCapability> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Set<ConnectorCapability> capabilities) {
        if (this.capabilities != capabilities) {
            this.capabilities.clear();
            if (capabilities != null && !capabilities.isEmpty()) {
                this.capabilities.addAll(capabilities);
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Integer getConnRequestTimeout() {
        return this.connRequestTimeout;
    }

    public void setConnRequestTimeout(Integer connRequestTimeout) {
        this.connRequestTimeout = connRequestTimeout;
    }
}

