/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;

public class DeleteIdentityLinkForProcessDefinitionCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String userId;
    protected String groupId;

    public DeleteIdentityLinkForProcessDefinitionCmd(String processDefinitionId, String userId, String groupId) {
        this.validateParams(userId, groupId, processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        this.userId = userId;
        this.groupId = groupId;
    }

    protected void validateParams(String userId, String groupId, String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("processDefinitionId is null");
        }
        if (userId == null && groupId == null) {
            throw new ActivitiIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Cannot find process definition with id " + this.processDefinitionId, ProcessDefinition.class);
        }
        processDefinition.deleteIdentityLink(this.userId, this.groupId);
        return null;
    }
}

