/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class MapperMethod {
    private final SqlCommand command;
    private final MethodSignature method;

    public MapperMethod(Class<?> mapperInterface, Method method, Configuration config) {
        this.command = new SqlCommand(config, mapperInterface, method);
        this.method = new MethodSignature(config, method);
    }

    public Object execute(SqlSession sqlSession, Object[] args) {
        Map result;
        if (SqlCommandType.INSERT == this.command.getType()) {
            Object param = this.method.convertArgsToSqlCommandParam(args);
            result = this.rowCountResult(sqlSession.insert(this.command.getName(), param));
        } else if (SqlCommandType.UPDATE == this.command.getType()) {
            Object param = this.method.convertArgsToSqlCommandParam(args);
            result = this.rowCountResult(sqlSession.update(this.command.getName(), param));
        } else if (SqlCommandType.DELETE == this.command.getType()) {
            Object param = this.method.convertArgsToSqlCommandParam(args);
            result = this.rowCountResult(sqlSession.delete(this.command.getName(), param));
        } else if (SqlCommandType.SELECT == this.command.getType()) {
            if (this.method.returnsVoid() && this.method.hasResultHandler()) {
                this.executeWithResultHandler(sqlSession, args);
                result = null;
            } else if (this.method.returnsMany()) {
                result = this.executeForMany(sqlSession, args);
            } else if (this.method.returnsMap()) {
                result = this.executeForMap(sqlSession, args);
            } else {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = sqlSession.selectOne(this.command.getName(), param);
            }
        } else {
            throw new BindingException("Unknown execution method for: " + this.command.getName());
        }
        if (result == null && this.method.getReturnType().isPrimitive() && !this.method.returnsVoid()) {
            throw new BindingException("Mapper method '" + this.command.getName() + " attempted to return null from a method with a primitive return type (" + this.method.getReturnType() + ").");
        }
        return result;
    }

    private Object rowCountResult(int rowCount) {
        Constable result;
        if (this.method.returnsVoid()) {
            result = null;
        } else if (Integer.class.equals(this.method.getReturnType()) || Integer.TYPE.equals(this.method.getReturnType())) {
            result = rowCount;
        } else if (Long.class.equals(this.method.getReturnType()) || Long.TYPE.equals(this.method.getReturnType())) {
            result = rowCount;
        } else if (Boolean.class.equals(this.method.getReturnType()) || Boolean.TYPE.equals(this.method.getReturnType())) {
            result = Boolean.valueOf(rowCount > 0);
        } else {
            throw new BindingException("Mapper method '" + this.command.getName() + "' has an unsupported return type: " + this.method.getReturnType());
        }
        return result;
    }

    private void executeWithResultHandler(SqlSession sqlSession, Object[] args) {
        MappedStatement ms = sqlSession.getConfiguration().getMappedStatement(this.command.getName());
        if (Void.TYPE.equals(ms.getResultMaps().get(0).getType())) {
            throw new BindingException("method " + this.command.getName() + " needs either a @ResultMap annotation, a @ResultType annotation," + " or a resultType attribute in XML so a ResultHandler can be used as a parameter.");
        }
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            sqlSession.select(this.command.getName(), param, rowBounds, this.method.extractResultHandler(args));
        } else {
            sqlSession.select(this.command.getName(), param, this.method.extractResultHandler(args));
        }
    }

    private <E> Object executeForMany(SqlSession sqlSession, Object[] args) {
        List result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectList(this.command.getName(), param, rowBounds);
        } else {
            result = sqlSession.selectList(this.command.getName(), param);
        }
        if (!this.method.getReturnType().isAssignableFrom(result.getClass())) {
            if (this.method.getReturnType().isArray()) {
                return this.convertToArray(result);
            }
            return this.convertToDeclaredCollection(sqlSession.getConfiguration(), result);
        }
        return result;
    }

    private <E> Object convertToDeclaredCollection(Configuration config, List<E> list) {
        Object collection = config.getObjectFactory().create(this.method.getReturnType());
        MetaObject metaObject = config.newMetaObject(collection);
        metaObject.addAll(list);
        return collection;
    }

    private <E> E[] convertToArray(List<E> list) {
        Object[] array = (Object[])Array.newInstance(this.method.getReturnType().getComponentType(), list.size());
        array = list.toArray(array);
        return array;
    }

    private <K, V> Map<K, V> executeForMap(SqlSession sqlSession, Object[] args) {
        Map result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectMap(this.command.getName(), param, this.method.getMapKey(), rowBounds);
        } else {
            result = sqlSession.selectMap(this.command.getName(), param, this.method.getMapKey());
        }
        return result;
    }

    public static class MethodSignature {
        private final boolean returnsMany;
        private final boolean returnsMap;
        private final boolean returnsVoid;
        private final Class<?> returnType;
        private final String mapKey;
        private final Integer resultHandlerIndex;
        private final Integer rowBoundsIndex;
        private final SortedMap<Integer, String> params;
        private final boolean hasNamedParameters;

        public MethodSignature(Configuration configuration, Method method) throws BindingException {
            this.returnType = method.getReturnType();
            this.returnsVoid = Void.TYPE.equals(this.returnType);
            this.returnsMany = configuration.getObjectFactory().isCollection(this.returnType) || this.returnType.isArray();
            this.mapKey = this.getMapKey(method);
            this.returnsMap = this.mapKey != null;
            this.hasNamedParameters = this.hasNamedParams(method);
            this.rowBoundsIndex = this.getUniqueParamIndex(method, RowBounds.class);
            this.resultHandlerIndex = this.getUniqueParamIndex(method, ResultHandler.class);
            this.params = Collections.unmodifiableSortedMap(this.getParams(method, this.hasNamedParameters));
        }

        public Object convertArgsToSqlCommandParam(Object[] args) {
            int paramCount = this.params.size();
            if (args == null || paramCount == 0) {
                return null;
            }
            if (!this.hasNamedParameters && paramCount == 1) {
                return args[this.params.keySet().iterator().next()];
            }
            ParamMap<Object> param = new ParamMap<Object>();
            int i = 0;
            for (Map.Entry<Integer, String> entry : this.params.entrySet()) {
                param.put(entry.getValue(), args[entry.getKey()]);
                String genericParamName = "param" + String.valueOf(i + 1);
                if (!param.containsKey(genericParamName)) {
                    param.put(genericParamName, args[entry.getKey()]);
                }
                ++i;
            }
            return param;
        }

        public boolean hasRowBounds() {
            return this.rowBoundsIndex != null;
        }

        public RowBounds extractRowBounds(Object[] args) {
            return this.hasRowBounds() ? (RowBounds)args[this.rowBoundsIndex] : null;
        }

        public boolean hasResultHandler() {
            return this.resultHandlerIndex != null;
        }

        public ResultHandler extractResultHandler(Object[] args) {
            return this.hasResultHandler() ? (ResultHandler)args[this.resultHandlerIndex] : null;
        }

        public String getMapKey() {
            return this.mapKey;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public boolean returnsMany() {
            return this.returnsMany;
        }

        public boolean returnsMap() {
            return this.returnsMap;
        }

        public boolean returnsVoid() {
            return this.returnsVoid;
        }

        private Integer getUniqueParamIndex(Method method, Class<?> paramType) {
            Integer index = null;
            Class<?>[] argTypes = method.getParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                if (!paramType.isAssignableFrom(argTypes[i])) continue;
                if (index == null) {
                    index = i;
                    continue;
                }
                throw new BindingException(method.getName() + " cannot have multiple " + paramType.getSimpleName() + " parameters");
            }
            return index;
        }

        private String getMapKey(Method method) {
            MapKey mapKeyAnnotation;
            String mapKey = null;
            if (Map.class.isAssignableFrom(method.getReturnType()) && (mapKeyAnnotation = method.getAnnotation(MapKey.class)) != null) {
                mapKey = mapKeyAnnotation.value();
            }
            return mapKey;
        }

        private SortedMap<Integer, String> getParams(Method method, boolean hasNamedParameters) {
            TreeMap<Integer, String> params = new TreeMap<Integer, String>();
            Class<?>[] argTypes = method.getParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                if (RowBounds.class.isAssignableFrom(argTypes[i]) || ResultHandler.class.isAssignableFrom(argTypes[i])) continue;
                String paramName = String.valueOf(params.size());
                if (hasNamedParameters) {
                    paramName = this.getParamNameFromAnnotation(method, i, paramName);
                }
                params.put(i, paramName);
            }
            return params;
        }

        private String getParamNameFromAnnotation(Method method, int i, String paramName) {
            Annotation[] paramAnnos;
            for (Annotation paramAnno : paramAnnos = method.getParameterAnnotations()[i]) {
                if (!(paramAnno instanceof Param)) continue;
                paramName = ((Param)paramAnno).value();
            }
            return paramName;
        }

        private boolean hasNamedParams(Method method) {
            Annotation[][] paramAnnos;
            boolean hasNamedParams = false;
            Annotation[][] arr$ = paramAnnos = method.getParameterAnnotations();
            int len$ = arr$.length;
            block0: for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] paramAnno;
                for (Annotation aParamAnno : paramAnno = arr$[i$]) {
                    if (!(aParamAnno instanceof Param)) continue;
                    hasNamedParams = true;
                    continue block0;
                }
            }
            return hasNamedParams;
        }
    }

    public static class SqlCommand {
        private final String name;
        private final SqlCommandType type;

        public SqlCommand(Configuration configuration, Class<?> declaringInterface, Method method) throws BindingException {
            MappedStatement ms;
            this.name = declaringInterface.getName() + "." + method.getName();
            try {
                ms = configuration.getMappedStatement(this.name);
            }
            catch (Exception e) {
                throw new BindingException("Invalid bound statement (not found): " + this.name, e);
            }
            this.type = ms.getSqlCommandType();
            if (this.type == SqlCommandType.UNKNOWN) {
                throw new BindingException("Unknown execution method for: " + this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public SqlCommandType getType() {
            return this.type;
        }
    }

    public static class ParamMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -2212268410512043556L;

        @Override
        public V get(Object key) {
            if (!super.containsKey(key)) {
                throw new BindingException("Parameter '" + key + "' not found. Available parameters are " + this.keySet());
            }
            return super.get(key);
        }
    }
}

