/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.JobClassTO;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.SyncActionClassTO;
import org.apache.syncope.common.to.TaskExecTO;
import org.apache.syncope.common.to.TaskTO;
import org.apache.syncope.common.types.TaskType;

@Path(value="tasks")
public interface TaskService {
    @GET
    @Path(value="{type}/count")
    public int count(@PathParam(value="type") TaskType var1);

    @POST
    public Response create(TaskTO var1);

    @DELETE
    @Path(value="{taskId}")
    public void delete(@PathParam(value="taskId") Long var1);

    @DELETE
    @Path(value="executions/{executionId}")
    public void deleteExecution(@PathParam(value="executionId") Long var1);

    @POST
    @Path(value="{taskId}/execute")
    public TaskExecTO execute(@PathParam(value="taskId") Long var1, @QueryParam(value="dryRun") @DefaultValue(value="false") boolean var2);

    @GET
    @Path(value="jobClasses")
    public Set<JobClassTO> getJobClasses();

    @GET
    @Path(value="syncActionsClasses")
    public Set<SyncActionClassTO> getSyncActionsClasses();

    @GET
    @Path(value="{type}/list")
    public List<? extends TaskTO> list(@PathParam(value="type") TaskType var1);

    @GET
    @Path(value="{type}")
    public List<? extends TaskTO> list(@PathParam(value="type") TaskType var1, @QueryParam(value="page") int var2, @QueryParam(value="size") @DefaultValue(value="25") int var3);

    @GET
    @Path(value="{type}/{taskId}")
    public <T extends TaskTO> T read(@PathParam(value="type") TaskType var1, @PathParam(value="taskId") Long var2);

    @GET
    @Path(value="executions/{executionId}")
    public TaskExecTO readExecution(@PathParam(value="executionId") Long var1);

    @POST
    @Path(value="executions/{executionId}/report")
    public void report(@PathParam(value="executionId") Long var1, ReportExecTO var2);

    @PUT
    @Path(value="{taskId}")
    public void update(@PathParam(value="taskId") Long var1, TaskTO var2);

    @POST
    @Path(value="bulk")
    public BulkActionRes bulkAction(BulkAction var1);
}

