/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax;

import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.sax.AbstractSAXProducer;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.util.SAXConsumerAdapter;
import org.apache.cocoon.xml.sax.SAXBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractSAXTransformer
extends AbstractSAXProducer
implements SAXConsumer {
    private List<String[]> namespaces = new ArrayList<String[]>();
    private SAXConsumer originalSAXConsumer;
    private boolean isRecording;

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.getSAXConsumer().characters(ch, start, length);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.getSAXConsumer().comment(ch, start, length);
    }

    public void endCDATA() throws SAXException {
        this.getSAXConsumer().endCDATA();
    }

    public void endDocument() throws SAXException {
        this.getSAXConsumer().endDocument();
    }

    public void endDTD() throws SAXException {
        this.getSAXConsumer().endDTD();
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.getSAXConsumer().endElement(uri, localName, name);
    }

    public void endEntity(String name) throws SAXException {
        this.getSAXConsumer().endEntity(name);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (prefix != null) {
            boolean found = false;
            for (int i = this.namespaces.size() - 1; i >= 0; --i) {
                String[] prefixAndUri = this.namespaces.get(i);
                if (!prefixAndUri[0].equals(prefix)) continue;
                this.namespaces.remove(i);
                found = true;
                break;
            }
            if (!found) {
                throw new SAXException("Namespace for prefix '" + prefix + "' not found.");
            }
        }
        this.getSAXConsumer().endPrefixMapping(prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.getSAXConsumer().ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.getSAXConsumer().processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this.getSAXConsumer().setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this.getSAXConsumer().skippedEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.getSAXConsumer().startCDATA();
    }

    public void startDocument() throws SAXException {
        this.getSAXConsumer().startDocument();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.getSAXConsumer().startDTD(name, publicId, systemId);
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.getSAXConsumer().startElement(uri, localName, name, atts);
    }

    public void startEntity(String name) throws SAXException {
        this.getSAXConsumer().startEntity(name);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix != null) {
            this.namespaces.add(new String[]{prefix, uri});
        }
        this.getSAXConsumer().startPrefixMapping(prefix, uri);
    }

    protected void setRecorder(ContentHandler recorder) {
        if (this.isRecording) {
            throw new ProcessingException("Only one recorder can be set.");
        }
        this.isRecording = true;
        this.originalSAXConsumer = this.getSAXConsumer();
        SAXConsumerAdapter saxConsumerAdapter = new SAXConsumerAdapter();
        saxConsumerAdapter.setContentHandler(recorder);
        this.setSAXConsumer(saxConsumerAdapter);
    }

    protected ContentHandler removeRecorder() {
        SAXConsumerAdapter saxBufferAdapter = (SAXConsumerAdapter)this.getSAXConsumer();
        this.setSAXConsumer(this.originalSAXConsumer);
        this.isRecording = false;
        return saxBufferAdapter.getContentHandler();
    }

    public void startSAXRecording() throws SAXException {
        this.setRecorder((ContentHandler)new SAXBuffer());
        this.sendStartPrefixMapping();
    }

    public SAXBuffer endSAXRecording() throws SAXException {
        this.sendEndPrefixMapping();
        return (SAXBuffer)this.removeRecorder();
    }

    protected void sendStartPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = this.namespaces.get(i);
            super.getSAXConsumer().startPrefixMapping(prefixAndUri[0], prefixAndUri[1]);
        }
    }

    protected void sendEndPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = this.namespaces.get(i);
            this.getSAXConsumer().endPrefixMapping(prefixAndUri[0]);
        }
    }
}

