/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class Select<T>
extends FormComponent<T> {
    private static final long serialVersionUID = 1L;

    public Select(String id) {
        super(id);
    }

    public Select(String id, IModel<T> model) {
        super(id, model);
    }

    protected String getModelValue() {
        final StringBuilder builder = new StringBuilder();
        this.visitChildren(SelectOption.class, new IVisitor<SelectOption<T>, Void>(){

            public void component(SelectOption<T> option, IVisit<Void> visit) {
                if (Select.this.isSelected(option.getDefaultModel())) {
                    if (builder.length() > 0) {
                        builder.append(";");
                    }
                    builder.append(option.getValue());
                }
            }
        });
        return builder.toString();
    }

    protected void convertInput() {
        boolean supportsMultiple = this.getModelObject() instanceof Collection;
        Object[] values = this.getInputAsArray();
        if (values == null || values.length == 0) {
            this.setConvertedInput(null);
            return;
        }
        if (!supportsMultiple && values.length > 1) {
            throw new WicketRuntimeException("The model of Select component [" + this.getPath() + "] is not of type java.util.Collection, but more then one SelectOption component has been selected. Either remove the multiple attribute from the select tag or make the model of the Select component a collection");
        }
        ArrayList<Object> converted = new ArrayList<Object>(values.length);
        for (int i = 0; i < values.length; ++i) {
            final String value = values[i];
            if (Strings.isEmpty((CharSequence)value)) continue;
            SelectOption option = (SelectOption)((Object)this.visitChildren(SelectOption.class, new IVisitor<SelectOption<T>, SelectOption<T>>(){

                public void component(SelectOption<T> option, IVisit<SelectOption<T>> visit) {
                    if (String.valueOf(option.getValue()).equals(value)) {
                        visit.stop(option);
                    }
                }
            }));
            if (option == null) {
                throw new WicketRuntimeException("submitted http post value [" + Arrays.toString(values) + "] for SelectOption component [" + this.getPath() + "] contains an illegal value [" + value + "] which does not point to a SelectOption component. Due to this the Select component cannot resolve the selected SelectOption component pointed to by the illegal value. A possible reason is that component hierarchy changed between rendering and form submission.");
            }
            converted.add(option.getDefaultModelObject());
        }
        if (converted.isEmpty()) {
            this.setConvertedInput(null);
        } else if (!supportsMultiple) {
            Object convertedInput = converted.get(0);
            this.setConvertedInput(convertedInput);
        } else {
            ArrayList<Object> convertedInput = converted;
            this.setConvertedInput(convertedInput);
        }
    }

    public void updateModel() {
        Object object = this.getModelObject();
        boolean supportsMultiple = object instanceof Collection;
        Object converted = this.getConvertedInput();
        if (supportsMultiple) {
            Collection modelCollection = (Collection)object;
            this.modelChanging();
            modelCollection.clear();
            if (converted != null) {
                modelCollection.addAll((Collection)converted);
            }
            this.modelChanged();
            this.setDefaultModelObject(modelCollection);
        } else {
            this.setDefaultModelObject(converted);
        }
    }

    boolean isSelected(SelectOption<?> option) {
        Args.notNull(option, (String)"option");
        if (this.hasRawInput()) {
            String raw = this.getRawInput();
            if (!Strings.isEmpty((CharSequence)raw)) {
                String[] values = raw.split(";");
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (!value.equals(option.getValue())) continue;
                    return true;
                }
            }
            return false;
        }
        return this.isSelected(option.getDefaultModel());
    }

    protected boolean isSelected(IModel<?> model) {
        return this.compareModels(this.getDefaultModelObject(), model.getObject());
    }

    private boolean compareModels(Object selected, Object value) {
        if (selected != null && selected instanceof Collection) {
            if (value instanceof Collection) {
                return ((Collection)selected).containsAll((Collection)value);
            }
            return ((Collection)selected).contains(value);
        }
        return Objects.equal((Object)selected, (Object)value);
    }
}

