/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.delegate.TaskListenerInvocation;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.VariableInitializingList;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class TaskEntity
extends VariableScopeImpl
implements Task,
DelegateTask,
Serializable,
PersistentObject,
HasRevision {
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    private static final long serialVersionUID = 1L;
    protected int revision;
    protected String owner;
    protected String assignee;
    protected DelegationState delegationState;
    protected String parentTaskId;
    protected String name;
    protected String description;
    protected int priority = 50;
    protected Date createTime;
    protected Date dueDate;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected boolean isIdentityLinksInitialized = false;
    protected List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String executionId;
    protected ExecutionEntity execution;
    protected String processInstanceId;
    protected ExecutionEntity processInstance;
    protected String processDefinitionId;
    protected TaskDefinition taskDefinition;
    protected String taskDefinitionKey;
    protected boolean isDeleted;
    protected String eventName;
    protected List<VariableInstanceEntity> queryVariables;

    public TaskEntity() {
    }

    public TaskEntity(String taskId) {
        this.id = taskId;
    }

    public static TaskEntity createAndInsert(ActivityExecution execution) {
        TaskEntity task = TaskEntity.create();
        task.insert((ExecutionEntity)execution);
        return task;
    }

    public void insert(ExecutionEntity execution) {
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.insert(this);
        if (execution != null) {
            execution.addTask(this);
        }
        commandContext.getHistoryManager().recordTaskCreated(this, execution);
    }

    public void update() {
        this.setOwner(this.getOwner());
        this.setAssignee(this.getAssignee());
        this.setDelegationState(this.getDelegationState());
        this.setName(this.getName());
        this.setDescription(this.getDescription());
        this.setPriority(this.getPriority());
        this.setCreateTime(this.getCreateTime());
        this.setDueDate(this.getDueDate());
        this.setParentTaskId(this.getParentTaskId());
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update(this);
    }

    public static TaskEntity create() {
        TaskEntity task = new TaskEntity();
        task.isIdentityLinksInitialized = true;
        task.createTime = ClockUtil.getCurrentTime();
        return task;
    }

    public void complete() {
        this.fireEvent("complete");
        if (Authentication.getAuthenticatedUserId() != null && this.processInstanceId != null) {
            this.getProcessInstance().involveUser(Authentication.getAuthenticatedUserId(), "participant");
        }
        Context.getCommandContext().getTaskEntityManager().deleteTask(this, DELETE_REASON_COMPLETED, false);
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            execution.removeTask(this);
            execution.signal(null, null);
        }
    }

    @Override
    public void delegate(String userId) {
        this.setDelegationState(DelegationState.PENDING);
        if (this.getOwner() == null) {
            this.setOwner(this.getAssignee());
        }
        this.setAssignee(userId);
    }

    public void resolve() {
        this.setDelegationState(DelegationState.RESOLVED);
        this.setAssignee(this.owner);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("assignee", this.assignee);
        persistentState.put("owner", this.owner);
        persistentState.put("name", this.name);
        persistentState.put("priority", this.priority);
        if (this.executionId != null) {
            persistentState.put("executionId", this.executionId);
        }
        if (this.processDefinitionId != null) {
            persistentState.put("processDefinitionId", this.processDefinitionId);
        }
        if (this.createTime != null) {
            persistentState.put("createTime", this.createTime);
        }
        if (this.description != null) {
            persistentState.put("description", this.description);
        }
        if (this.dueDate != null) {
            persistentState.put("dueDate", this.dueDate);
        }
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.delegationState != null) {
            persistentState.put("delegationState", (Object)this.delegationState);
        }
        persistentState.put("suspensionState", this.suspensionState);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        if (this.getExecution() != null) {
            return this.execution;
        }
        return null;
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setTaskId(this.id);
        variableInstance.setExecutionId(this.executionId);
        variableInstance.setProcessInstanceId(this.processInstanceId);
    }

    @Override
    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByTaskId(this.id);
    }

    @Override
    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(DelegateExecution execution) {
        if (execution != null) {
            this.execution = (ExecutionEntity)execution;
            this.executionId = this.execution.getId();
            this.processInstanceId = this.execution.getProcessInstanceId();
            this.processDefinitionId = this.execution.getProcessDefinitionId();
            Context.getCommandContext().getHistoryManager().recordTaskExecutionIdChange(this.id, this.executionId);
        } else {
            this.execution = null;
            this.executionId = null;
            this.processInstanceId = null;
            this.processDefinitionId = null;
        }
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setTask(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        identityLinkEntity.insert();
        if (userId != null && this.processInstanceId != null) {
            this.getProcessInstance().involveUser(userId, "participant");
        }
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinkByTaskUserGroupAndType(this.id, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(identityLink, true);
        }
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType()) || (userId == null || !userId.equals(identityLinkEntity.getUserId())) && (groupId == null || !identityLinkEntity.getGroupId().equals(groupId))) continue;
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(identityLinkEntity, true);
            removedIdentityLinkEntities.add(identityLinkEntity);
        }
        this.getIdentityLinks().removeAll(removedIdentityLinkEntities);
    }

    @Override
    public Set<IdentityLink> getCandidates() {
        HashSet<IdentityLink> potentialOwners = new HashSet<IdentityLink>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType())) continue;
            potentialOwners.add(identityLinkEntity);
        }
        return potentialOwners;
    }

    @Override
    public void addCandidateUser(String userId) {
        this.addIdentityLink(userId, null, "candidate");
    }

    @Override
    public void addCandidateUsers(Collection<String> candidateUsers) {
        for (String candidateUser : candidateUsers) {
            this.addCandidateUser(candidateUser);
        }
    }

    @Override
    public void addCandidateGroup(String groupId) {
        this.addIdentityLink(null, groupId, "candidate");
    }

    @Override
    public void addCandidateGroups(Collection<String> candidateGroups) {
        for (String candidateGroup : candidateGroups) {
            this.addCandidateGroup(candidateGroup);
        }
    }

    @Override
    public void addGroupIdentityLink(String groupId, String identityLinkType) {
        this.addIdentityLink(null, groupId, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(String userId, String identityLinkType) {
        this.addIdentityLink(userId, null, identityLinkType);
    }

    @Override
    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    @Override
    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    @Override
    public void deleteGroupIdentityLink(String groupId, String identityLinkType) {
        if (groupId != null) {
            this.deleteIdentityLink(null, groupId, identityLinkType);
        }
    }

    @Override
    public void deleteUserIdentityLink(String userId, String identityLinkType) {
        if (userId != null) {
            this.deleteIdentityLink(userId, null, identityLinkType);
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.taskIdentityLinkEntities = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByTaskId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    public Map<String, Object> getActivityInstanceVariables() {
        if (this.execution != null) {
            return this.execution.getVariables();
        }
        return Collections.EMPTY_MAP;
    }

    public void setExecutionVariables(Map<String, Object> parameters) {
        if (this.getExecution() != null) {
            this.execution.setVariables(parameters);
        }
    }

    public String toString() {
        return "Task[id=" + this.id + ", name=" + this.name + "]";
    }

    @Override
    public void setName(String taskName) {
        this.name = taskName;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskNameChange(this.id, taskName);
        }
    }

    public void setNameWithoutCascade(String taskName) {
        this.name = taskName;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDescriptionChange(this.id, description);
        }
    }

    public void setDescriptionWithoutCascade(String description) {
        this.description = description;
    }

    @Override
    public void setAssignee(String assignee) {
        if (assignee == null && this.assignee == null) {
            return;
        }
        this.assignee = assignee;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskAssigneeChange(this.id, assignee);
            if (assignee != null && this.processInstanceId != null) {
                this.getProcessInstance().involveUser(assignee, "participant");
            }
            this.fireEvent("assignment");
        }
    }

    public void setAssigneeWithoutCascade(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public void setOwner(String owner) {
        if (owner == null && this.owner == null) {
            return;
        }
        this.owner = owner;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskOwnerChange(this.id, owner);
            if (owner != null && this.processInstanceId != null) {
                this.getProcessInstance().involveUser(owner, "participant");
            }
        }
    }

    public void setOwnerWithoutCascade(String owner) {
        this.owner = owner;
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDueDateChange(this.id, dueDate);
        }
    }

    public void setDueDateWithoutCascade(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskPriorityChange(this.id, priority);
        }
    }

    public void setPriorityWithoutCascade(int priority) {
        this.priority = priority;
    }

    @Override
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskParentTaskIdChange(this.id, parentTaskId);
        }
    }

    public void setParentTaskIdWithoutCascade(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public void setTaskDefinitionKeyWithoutCascade(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public void fireEvent(String taskEventName) {
        List<TaskListener> taskEventListeners;
        TaskDefinition taskDefinition = this.getTaskDefinition();
        if (taskDefinition != null && (taskEventListeners = this.getTaskDefinition().getTaskListener(taskEventName)) != null) {
            for (TaskListener taskListener : taskEventListeners) {
                ExecutionEntity execution = this.getExecution();
                if (execution != null) {
                    this.setEventName(taskEventName);
                }
                try {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListener, this));
                }
                catch (Exception e) {
                    throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    protected boolean isActivityIdUsedForDetails() {
        return false;
    }

    public void setTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
        this.taskDefinitionKey = taskDefinition.getKey();
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDefinitionKeyChange(this, this.taskDefinitionKey);
        }
    }

    public TaskDefinition getTaskDefinition() {
        if (this.taskDefinition == null && this.taskDefinitionKey != null) {
            ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
        }
        return this.taskDefinition;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDefinitionKeyChange(this, taskDefinitionKey);
        }
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.processInstanceId);
        }
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    @Override
    public void setDelegationState(DelegationState delegationState) {
        this.delegationState = delegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public void setDelegationStateString(String delegationStateString) {
        this.delegationState = delegationStateString != null ? DelegationState.valueOf(DelegationState.class, delegationStateString) : null;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public Map<String, VariableInstanceEntity> getVariableInstances() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }
}

