/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.FieldExtension;
import org.apache.commons.lang3.StringUtils;

public class FieldExtensionExport
implements BpmnXMLConstants {
    public static boolean writeFieldExtensions(List<FieldExtension> fieldExtensionList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        for (FieldExtension fieldExtension : fieldExtensionList) {
            if (!StringUtils.isNotEmpty((CharSequence)fieldExtension.getFieldName()) || !StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue()) && !StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) continue;
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("activiti", "field", "http://activiti.org/bpmn");
            BpmnXMLUtil.writeDefaultAttribute("name", fieldExtension.getFieldName(), xtw);
            if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) {
                xtw.writeStartElement("activiti", "string", "http://activiti.org/bpmn");
                xtw.writeCharacters(fieldExtension.getStringValue());
            } else {
                xtw.writeStartElement("activiti", "expression", "http://activiti.org/bpmn");
                xtw.writeCharacters(fieldExtension.getExpression());
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }
}

